/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.cloud.config.server.environment.EnvironmentController;
import org.springframework.cloud.config.server.environment.EnvironmentEncryptorEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.ResourceController;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
public class ConfigServerMvcConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private EnvironmentRepository repository;
    @Autowired
    private ConfigServerProperties server;
    @Autowired(required=false)
    private EnvironmentEncryptor environmentEncryptor;
    @Autowired(required=false)
    private ObjectMapper objectMapper = new ObjectMapper();

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.mediaType("properties", MediaType.valueOf((String)"text/plain"));
        configurer.mediaType("yml", MediaType.valueOf((String)"text/yaml"));
        configurer.mediaType("yaml", MediaType.valueOf((String)"text/yaml"));
    }

    @Bean
    public EnvironmentController environmentController() {
        EnvironmentController controller = new EnvironmentController(this.encrypted(), this.objectMapper);
        controller.setStripDocumentFromYaml(this.server.isStripDocumentFromYaml());
        return controller;
    }

    @Bean
    @ConditionalOnBean(value={ResourceRepository.class})
    public ResourceController resourceController(ResourceRepository repository) {
        ResourceController controller = new ResourceController(repository, this.encrypted());
        return controller;
    }

    private EnvironmentRepository encrypted() {
        EnvironmentEncryptorEnvironmentRepository encrypted = new EnvironmentEncryptorEnvironmentRepository(this.repository, this.environmentEncryptor);
        encrypted.setOverrides(this.server.getOverrides());
        return encrypted;
    }
}

