/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.Profiles;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.RetryProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ConfigServerConfigDataResource
extends ConfigDataResource {
    private final ConfigClientProperties properties;
    private final boolean optional;
    private final Profiles profiles;
    private RetryProperties retryProperties;
    private Log log;
    private boolean isProfileSpecific = false;

    public ConfigServerConfigDataResource(ConfigClientProperties properties, boolean optional, Profiles profiles) {
        this.properties = properties;
        this.optional = optional;
        this.profiles = profiles;
    }

    public ConfigClientProperties getProperties() {
        return this.properties;
    }

    public boolean isProfileSpecific() {
        return this.isProfileSpecific;
    }

    public void setProfileSpecific(boolean profileSpecific) {
        this.isProfileSpecific = profileSpecific;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getProfiles() {
        if (StringUtils.hasText((String)this.properties.getProfile()) && !this.properties.getProfile().equals("default")) {
            return this.properties.getProfile();
        }
        return StringUtils.collectionToCommaDelimitedString(this.getAcceptedProfiles());
    }

    List<String> getAcceptedProfiles() {
        if (this.profiles == null) {
            return Collections.singletonList(!this.properties.getProfile().equals("default") ? this.properties.getProfile() : "default");
        }
        return this.profiles.getAccepted();
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public RetryProperties getRetryProperties() {
        return this.retryProperties;
    }

    public void setRetryProperties(RetryProperties retryProperties) {
        this.retryProperties = retryProperties;
    }

    private String getApplicationName() {
        return ObjectUtils.isEmpty((Object)this.properties.getName()) ? "application" : this.getProperties().getName();
    }

    private String getProfilesForEquals() {
        return ObjectUtils.isEmpty((Object)this.getProfiles()) ? "default" : this.getProfiles();
    }

    private boolean urisEqual(String[] thatUris) {
        if (this.properties.getUri().length != thatUris.length) {
            return false;
        }
        for (String uri : this.properties.getUri()) {
            if (!Arrays.stream(thatUris).noneMatch(thatUri -> this.uriEqual(uri, (String)thatUri))) continue;
            return false;
        }
        return true;
    }

    private boolean uriEqual(String thisUriString, String thatUriString) {
        try {
            UriComponents thisUri = UriComponentsBuilder.fromHttpUrl((String)thisUriString).build();
            UriComponents thatUri = UriComponentsBuilder.fromHttpUrl((String)thatUriString).build();
            return Objects.equals(thisUri.getHost(), thatUri.getHost()) && Objects.equals(thisUri.getPort(), thatUri.getPort()) && Objects.equals(thisUri.getPath(), thatUri.getPath());
        }
        catch (Exception e) {
            return Objects.equals(thisUriString, thatUriString);
        }
    }

    private int urisHashCode(String[] uris) {
        return Arrays.stream(uris).mapToInt(uriString -> {
            try {
                UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)uriString).build();
                return Objects.hash(uriComponents.getHost(), uriComponents.getPath(), uriComponents.getPort());
            }
            catch (Exception e) {
                return Arrays.hashCode(uris);
            }
        }).sum();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConfigServerConfigDataResource that = (ConfigServerConfigDataResource)((Object)o);
        return this.urisEqual(that.properties.getUri()) && Objects.equals(this.getApplicationName(), that.getApplicationName()) && Objects.equals(this.properties.getLabel(), that.properties.getLabel()) && Objects.equals(this.getProfilesForEquals(), that.getProfilesForEquals()) && Objects.equals(this.optional, that.optional);
    }

    public int hashCode() {
        String[] uris = this.properties.getUri();
        String name = this.properties.getName();
        String label = this.properties.getLabel();
        return Objects.hash(this.urisHashCode(uris), name, label, this.optional, this.getProfilesForEquals());
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("uris", (Object)this.properties.getUri()).append("optional", this.optional).append("profiles", (Object)this.getProfiles()).toString();
    }
}

