/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.http.client.autoconfigure.service.HttpServiceClientProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.reactive.DeferringLoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancedExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerWebClientBuilderBeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerWebClientHttpServiceGroupConfigurer;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Primary;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
@Conditional(value={OnAnyLoadBalancerImplementationPresentCondition.class})
public class LoadBalancerBeanPostProcessorAutoConfiguration {
    @Bean
    public static LoadBalancerWebClientBuilderBeanPostProcessor loadBalancerWebClientBuilderBeanPostProcessor(ObjectProvider<DeferringLoadBalancerExchangeFilterFunction> deferringExchangeFilterFunction, ApplicationContext context) {
        return new LoadBalancerWebClientBuilderBeanPostProcessor(deferringExchangeFilterFunction, context);
    }

    static final class OnAnyLoadBalancerImplementationPresentCondition
    extends AnyNestedCondition {
        private OnAnyLoadBalancerImplementationPresentCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={LoadBalancerClient.class})
        static class LoadBalancerClientPresent {
            LoadBalancerClientPresent() {
            }
        }

        @ConditionalOnBean(value={ReactiveLoadBalancer.Factory.class})
        static class ReactiveLoadBalancerFactoryPresent {
            ReactiveLoadBalancerFactoryPresent() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpServiceClientProperties.class})
    @ConditionalOnBean(value={ReactiveLoadBalancer.Factory.class})
    protected static class ReactorDeferringLoadBalancerFilterHttpClientConfig {
        protected ReactorDeferringLoadBalancerFilterHttpClientConfig() {
        }

        @Bean
        @ConditionalOnBean(value={HttpServiceClientProperties.class, ReactiveLoadBalancer.Factory.class})
        @ConditionalOnMissingBean(value={LoadBalancerWebClientHttpServiceGroupConfigurer.class})
        LoadBalancerWebClientHttpServiceGroupConfigurer loadBalancerWebClientHttpServiceGroupConfigurer(ObjectProvider<DeferringLoadBalancerExchangeFilterFunction<LoadBalancedExchangeFilterFunction>> deferringExchangeFilterFunction, HttpServiceClientProperties properties) {
            return new LoadBalancerWebClientHttpServiceGroupConfigurer(deferringExchangeFilterFunction, properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ReactiveLoadBalancer.Factory.class})
    protected static class ReactorDeferringLoadBalancerFilterConfig {
        protected ReactorDeferringLoadBalancerFilterConfig() {
        }

        @Bean
        @Primary
        static DeferringLoadBalancerExchangeFilterFunction<LoadBalancedExchangeFilterFunction> reactorDeferringLoadBalancerExchangeFilterFunction(ObjectProvider<LoadBalancedExchangeFilterFunction> exchangeFilterFunctionProvider) {
            return new DeferringLoadBalancerExchangeFilterFunction<LoadBalancedExchangeFilterFunction>(exchangeFilterFunctionProvider);
        }
    }
}

