/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.springframework.cloud.client.loadbalancer.RetryableStatusCodeException;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class LoadBalancerProperties {
    private HealthCheck healthCheck = new HealthCheck();
    private Map<String, String> hint = new LinkedCaseInsensitiveMap();
    private String hintHeaderName = "X-SC-LB-Hint";
    private Retry retry = new Retry();
    private StickySession stickySession = new StickySession();
    private boolean callGetWithRequestOnDelegates = true;
    private Subset subset = new Subset();
    private XForwarded xForwarded = new XForwarded();
    private Stats stats = new Stats();

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public Map<String, String> getHint() {
        return this.hint;
    }

    public void setHint(Map<String, String> hint) {
        this.hint = hint;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public void setRetry(Retry retry) {
        this.retry = retry;
    }

    public StickySession getStickySession() {
        return this.stickySession;
    }

    public void setStickySession(StickySession stickySession) {
        this.stickySession = stickySession;
    }

    public String getHintHeaderName() {
        return this.hintHeaderName;
    }

    public void setHintHeaderName(String hintHeaderName) {
        this.hintHeaderName = hintHeaderName;
    }

    public void setXForwarded(XForwarded xForwarded) {
        this.xForwarded = xForwarded;
    }

    public XForwarded getXForwarded() {
        return this.xForwarded;
    }

    public boolean isCallGetWithRequestOnDelegates() {
        return this.callGetWithRequestOnDelegates;
    }

    public Subset getSubset() {
        return this.subset;
    }

    public void setSubset(Subset subset) {
        this.subset = subset;
    }

    public void setCallGetWithRequestOnDelegates(boolean callGetWithRequestOnDelegates) {
        this.callGetWithRequestOnDelegates = callGetWithRequestOnDelegates;
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public static class HealthCheck {
        private Duration initialDelay = Duration.ZERO;
        private Duration interval = Duration.ofSeconds(25L);
        private Duration refetchInstancesInterval = Duration.ofSeconds(25L);
        private Map<String, String> path = new LinkedCaseInsensitiveMap();
        private Integer port;
        private boolean refetchInstances = false;
        private boolean repeatHealthCheck = true;
        private boolean updateResultsList = true;

        public boolean getRefetchInstances() {
            return this.refetchInstances;
        }

        public void setRefetchInstances(boolean refetchInstances) {
            this.refetchInstances = refetchInstances;
        }

        public boolean getRepeatHealthCheck() {
            return this.repeatHealthCheck;
        }

        public void setRepeatHealthCheck(boolean repeatHealthCheck) {
            this.repeatHealthCheck = repeatHealthCheck;
        }

        public Duration getInitialDelay() {
            return this.initialDelay;
        }

        public void setInitialDelay(Duration initialDelay) {
            this.initialDelay = initialDelay;
        }

        public Duration getRefetchInstancesInterval() {
            return this.refetchInstancesInterval;
        }

        public void setRefetchInstancesInterval(Duration refetchInstancesInterval) {
            this.refetchInstancesInterval = refetchInstancesInterval;
        }

        public Map<String, String> getPath() {
            return this.path;
        }

        public void setPath(Map<String, String> path) {
            this.path = path;
        }

        public Duration getInterval() {
            return this.interval;
        }

        public void setInterval(Duration interval) {
            this.interval = interval;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public boolean isUpdateResultsList() {
            return this.updateResultsList;
        }

        public void setUpdateResultsList(boolean updateResultsList) {
            this.updateResultsList = updateResultsList;
        }
    }

    public static class Retry {
        private boolean enabled = true;
        private boolean retryOnAllOperations = false;
        private boolean retryOnAllExceptions = false;
        private int maxRetriesOnSameServiceInstance = 0;
        private int maxRetriesOnNextServiceInstance = 1;
        private Set<Integer> retryableStatusCodes = new HashSet<Integer>();
        private Set<Class<? extends Throwable>> retryableExceptions = new HashSet<Class>(Arrays.asList(IOException.class, TimeoutException.class, RetryableStatusCodeException.class, org.springframework.cloud.client.loadbalancer.reactive.RetryableStatusCodeException.class));
        private Backoff backoff = new Backoff();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isRetryOnAllOperations() {
            return this.retryOnAllOperations;
        }

        public void setRetryOnAllOperations(boolean retryOnAllOperations) {
            this.retryOnAllOperations = retryOnAllOperations;
        }

        public int getMaxRetriesOnSameServiceInstance() {
            return this.maxRetriesOnSameServiceInstance;
        }

        public void setMaxRetriesOnSameServiceInstance(int maxRetriesOnSameServiceInstance) {
            this.maxRetriesOnSameServiceInstance = maxRetriesOnSameServiceInstance;
        }

        public int getMaxRetriesOnNextServiceInstance() {
            return this.maxRetriesOnNextServiceInstance;
        }

        public void setMaxRetriesOnNextServiceInstance(int maxRetriesOnNextServiceInstance) {
            this.maxRetriesOnNextServiceInstance = maxRetriesOnNextServiceInstance;
        }

        public Set<Integer> getRetryableStatusCodes() {
            return this.retryableStatusCodes;
        }

        public void setRetryableStatusCodes(Set<Integer> retryableStatusCodes) {
            this.retryableStatusCodes = retryableStatusCodes;
        }

        public Set<Class<? extends Throwable>> getRetryableExceptions() {
            return this.retryableExceptions;
        }

        public void setRetryableExceptions(Set<Class<? extends Throwable>> retryableExceptions) {
            retryableExceptions.add(org.springframework.cloud.client.loadbalancer.reactive.RetryableStatusCodeException.class);
            this.retryableExceptions = retryableExceptions;
        }

        public Backoff getBackoff() {
            return this.backoff;
        }

        public void setBackoff(Backoff backoff) {
            this.backoff = backoff;
        }

        public boolean isRetryOnAllExceptions() {
            return this.retryOnAllExceptions;
        }

        public void setRetryOnAllExceptions(boolean retryOnAllExceptions) {
            this.retryOnAllExceptions = retryOnAllExceptions;
        }

        public static class Backoff {
            private boolean enabled = false;
            private Duration minBackoff = Duration.ofMillis(5L);
            private Duration maxBackoff = Duration.ofMillis(Long.MAX_VALUE);
            private double jitter = 0.5;

            public Duration getMinBackoff() {
                return this.minBackoff;
            }

            public void setMinBackoff(Duration minBackoff) {
                this.minBackoff = minBackoff;
            }

            public Duration getMaxBackoff() {
                return this.maxBackoff;
            }

            public void setMaxBackoff(Duration maxBackoff) {
                this.maxBackoff = maxBackoff;
            }

            public double getJitter() {
                return this.jitter;
            }

            public void setJitter(double jitter) {
                this.jitter = jitter;
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }

    public static class StickySession {
        private String instanceIdCookieName = "sc-lb-instance-id";
        private boolean addServiceInstanceCookie = false;

        public String getInstanceIdCookieName() {
            return this.instanceIdCookieName;
        }

        public void setInstanceIdCookieName(String instanceIdCookieName) {
            this.instanceIdCookieName = instanceIdCookieName;
        }

        public boolean isAddServiceInstanceCookie() {
            return this.addServiceInstanceCookie;
        }

        public void setAddServiceInstanceCookie(boolean addServiceInstanceCookie) {
            this.addServiceInstanceCookie = addServiceInstanceCookie;
        }
    }

    public static class Subset {
        private String instanceId = "";
        private int size = 100;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    public static class XForwarded {
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Stats {
        private boolean includePath = true;

        public boolean isIncludePath() {
            return this.includePath;
        }

        public void setIncludePath(boolean includePath) {
            this.includePath = includePath;
        }
    }
}

