/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.common.security.support.AuthoritiesMapper;
import org.springframework.cloud.common.security.support.CoreSecurityRoles;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class ExternalOauth2ResourceAuthoritiesMapper
implements AuthoritiesMapper {
    private static final Logger logger = LoggerFactory.getLogger(ExternalOauth2ResourceAuthoritiesMapper.class);
    public static final GrantedAuthority CREATE = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.CREATE.getKey());
    public static final GrantedAuthority DEPLOY = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.DEPLOY.getKey());
    public static final GrantedAuthority DESTROY = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.DESTROY.getKey());
    public static final GrantedAuthority MANAGE = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.MANAGE.getKey());
    public static final GrantedAuthority MODIFY = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.MODIFY.getKey());
    public static final GrantedAuthority SCHEDULE = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.SCHEDULE.getKey());
    public static final GrantedAuthority VIEW = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.VIEW.getKey());
    private final URI roleProviderUri;
    private final RestOperations restOperations;

    public ExternalOauth2ResourceAuthoritiesMapper(URI roleProviderUri) {
        Assert.notNull((Object)roleProviderUri, (String)"The provided roleProviderUri must not be null.");
        this.roleProviderUri = roleProviderUri;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        this.restOperations = restTemplate;
    }

    @Override
    public Set<GrantedAuthority> mapScopesToAuthorities(String providerId, Set<String> scopes, String token) {
        logger.debug("Getting permissions from {}", (Object)this.roleProviderUri);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", OAuth2AccessToken.TokenType.BEARER.getValue() + " " + token);
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity response = this.restOperations.exchange(this.roleProviderUri, HttpMethod.GET, entity, String[].class);
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        block9: for (String permission : (String[])response.getBody()) {
            if (StringUtils.isEmpty((Object)permission)) {
                logger.warn("Received an empty permission from {}", (Object)this.roleProviderUri);
                continue;
            }
            CoreSecurityRoles securityRole = CoreSecurityRoles.fromKey(permission.toUpperCase());
            if (securityRole == null) {
                logger.warn("Invalid role {} provided by {}", (Object)permission, (Object)this.roleProviderUri);
                continue;
            }
            switch (securityRole) {
                case CREATE: {
                    authorities.add(CREATE);
                    continue block9;
                }
                case DEPLOY: {
                    authorities.add(DEPLOY);
                    continue block9;
                }
                case DESTROY: {
                    authorities.add(DESTROY);
                    continue block9;
                }
                case MANAGE: {
                    authorities.add(MANAGE);
                    continue block9;
                }
                case MODIFY: {
                    authorities.add(MODIFY);
                    continue block9;
                }
                case SCHEDULE: {
                    authorities.add(SCHEDULE);
                    continue block9;
                }
                case VIEW: {
                    authorities.add(VIEW);
                }
            }
        }
        logger.info("Roles added for user: {}.", authorities);
        return authorities;
    }
}

