/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.common.security.ProviderRoleMapping;
import org.springframework.cloud.common.security.support.AuthoritiesMapper;
import org.springframework.cloud.common.security.support.CoreSecurityRoles;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultAuthoritiesMapper
implements AuthoritiesMapper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthoritiesMapper.class);
    private final Map<String, ProviderRoleMapping> providerRoleMappings;
    private final String defaultProviderId;

    public DefaultAuthoritiesMapper(Map<String, ProviderRoleMapping> providerRoleMappings, String defaultProviderId) {
        Assert.notNull(providerRoleMappings, (String)"providerRoleMappings must not be null.");
        for (Map.Entry<String, ProviderRoleMapping> providerRoleMappingToValidate : providerRoleMappings.entrySet()) {
            providerRoleMappingToValidate.getValue().convertRoleMappingKeysToCoreSecurityRoles();
        }
        this.providerRoleMappings = providerRoleMappings;
        this.defaultProviderId = defaultProviderId;
    }

    public DefaultAuthoritiesMapper(String providerId, boolean mapOAuthScopes, Map<String, String> roleMappings) {
        Assert.hasText((String)providerId, (String)"The providerId must not be null or empty.");
        ProviderRoleMapping providerRoleMapping = new ProviderRoleMapping(mapOAuthScopes, roleMappings);
        this.providerRoleMappings = new HashMap<String, ProviderRoleMapping>(1);
        this.providerRoleMappings.put(providerId, providerRoleMapping);
        for (ProviderRoleMapping providerRoleMappingToValidate : this.providerRoleMappings.values()) {
            providerRoleMappingToValidate.convertRoleMappingKeysToCoreSecurityRoles();
        }
        this.defaultProviderId = providerId;
    }

    public DefaultAuthoritiesMapper(String providerId, boolean mapOAuthScopes) {
        Assert.hasText((String)providerId, (String)"The providerId must not be null or empty.");
        ProviderRoleMapping providerRoleMapping = new ProviderRoleMapping(mapOAuthScopes);
        this.providerRoleMappings = new HashMap<String, ProviderRoleMapping>(1);
        this.providerRoleMappings.put(providerId, providerRoleMapping);
        for (ProviderRoleMapping providerRoleMappingToValidate : this.providerRoleMappings.values()) {
            providerRoleMappingToValidate.convertRoleMappingKeysToCoreSecurityRoles();
        }
        this.defaultProviderId = providerId;
    }

    public DefaultAuthoritiesMapper(String providerId, ProviderRoleMapping providerRoleMapping) {
        this.providerRoleMappings = new HashMap<String, ProviderRoleMapping>(1);
        this.providerRoleMappings.put(providerId, providerRoleMapping);
        for (ProviderRoleMapping providerRoleMappingToValidate : this.providerRoleMappings.values()) {
            providerRoleMappingToValidate.convertRoleMappingKeysToCoreSecurityRoles();
        }
        this.defaultProviderId = providerId;
    }

    @Override
    public Set<GrantedAuthority> mapScopesToAuthorities(String clientIdParam, Set<String> scopes, String token) {
        Set<Object> grantedAuthorities;
        String clientId = clientIdParam == null ? this.defaultProviderId : clientIdParam;
        Assert.notNull(scopes, (String)"The scopes argument must not be null.");
        ProviderRoleMapping roleMapping = this.providerRoleMappings.get(clientId);
        if (roleMapping == null) {
            throw new IllegalArgumentException("No role mapping found for clientId " + clientId);
        }
        ArrayList<String> rolesAsStrings = new ArrayList<String>();
        if (roleMapping.isMapOauthScopes()) {
            grantedAuthorities = new HashSet<GrantedAuthority>();
            if (!scopes.isEmpty()) {
                for (Map.Entry<CoreSecurityRoles, String> roleMappingEngtry : roleMapping.convertRoleMappingKeysToCoreSecurityRoles().entrySet()) {
                    CoreSecurityRoles role = roleMappingEngtry.getKey();
                    String expectedOAuthScope = roleMappingEngtry.getValue();
                    for (String scope : this.pathParts(scopes)) {
                        if (!scope.equalsIgnoreCase(expectedOAuthScope)) continue;
                        SimpleGrantedAuthority oauthRoleAuthority = new SimpleGrantedAuthority(roleMapping.getRolePrefix() + role.getKey());
                        rolesAsStrings.add(oauthRoleAuthority.getAuthority());
                        grantedAuthorities.add((GrantedAuthority)oauthRoleAuthority);
                    }
                }
                logger.info("Adding roles: {}.", (Object)StringUtils.collectionToCommaDelimitedString(rolesAsStrings));
            }
        } else {
            grantedAuthorities = roleMapping.convertRoleMappingKeysToCoreSecurityRoles().entrySet().stream().map(mapEntry -> {
                CoreSecurityRoles role = (CoreSecurityRoles)((Object)((Object)mapEntry.getKey()));
                rolesAsStrings.add(role.getKey());
                return new SimpleGrantedAuthority(roleMapping.getRolePrefix() + mapEntry.getKey());
            }).collect(Collectors.toSet());
            logger.info("Adding ALL roles: {}.", (Object)StringUtils.collectionToCommaDelimitedString(rolesAsStrings));
        }
        return grantedAuthorities;
    }

    private Set<String> pathParts(Set<String> scopes) {
        return scopes.stream().map(scope -> {
            try {
                URI uri = URI.create(scope);
                String path = uri.getPath();
                if (StringUtils.hasText((String)path) && path.charAt(0) == '/') {
                    return path.substring(1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return scope;
        }).collect(Collectors.toSet());
    }
}

