/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.cloud.common.security.support.CoreSecurityRoles;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultAuthoritiesExtractor
implements AuthoritiesExtractor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthoritiesExtractor.class);
    private final boolean mapOauthScopesToAuthorities;
    private final Map<CoreSecurityRoles, String> roleMappings;
    private String rolePrefix = "ROLE_";
    private String oauthScopePrefix = "dataflow.";
    private final OAuth2RestOperations restTemplate;

    public DefaultAuthoritiesExtractor(boolean mapOauthScopesToAuthorities, Map<String, String> roleMappings, OAuth2RestOperations restTemplate) {
        this.mapOauthScopesToAuthorities = mapOauthScopesToAuthorities;
        this.roleMappings = this.prepareRoleMappings(roleMappings);
        this.restTemplate = restTemplate;
    }

    public DefaultAuthoritiesExtractor() {
        this.mapOauthScopesToAuthorities = false;
        this.roleMappings = this.prepareRoleMappings(null);
        this.restTemplate = null;
    }

    public List<GrantedAuthority> extractAuthorities(Map<String, Object> map) {
        ArrayList<GrantedAuthority> grantedAuthorities;
        Assert.notNull(map, (String)"The map argument must not be null.");
        ArrayList<String> rolesAsStrings = new ArrayList<String>();
        if (this.mapOauthScopesToAuthorities) {
            Set scopes = this.restTemplate.getAccessToken().getScope();
            grantedAuthorities = new ArrayList();
            if (scopes != null && !scopes.isEmpty()) {
                for (Map.Entry<CoreSecurityRoles, String> roleMappingEngtry : this.roleMappings.entrySet()) {
                    CoreSecurityRoles role = roleMappingEngtry.getKey();
                    String expectedOAuthScope = roleMappingEngtry.getValue();
                    for (String scope : scopes) {
                        if (!scope.equalsIgnoreCase(expectedOAuthScope)) continue;
                        SimpleGrantedAuthority oauthRoleAuthority = new SimpleGrantedAuthority(this.rolePrefix + role.getKey());
                        rolesAsStrings.add(oauthRoleAuthority.getAuthority());
                        grantedAuthorities.add((GrantedAuthority)oauthRoleAuthority);
                    }
                }
                logger.info("Adding roles {} to user {}", (Object)StringUtils.collectionToCommaDelimitedString(rolesAsStrings), map);
            }
        } else {
            grantedAuthorities = this.roleMappings.entrySet().stream().map(mapEntry -> {
                String roleName = ((CoreSecurityRoles)((Object)((Object)mapEntry.getKey()))).getKey();
                rolesAsStrings.add(roleName);
                return new SimpleGrantedAuthority(this.rolePrefix + ((CoreSecurityRoles)((Object)((Object)mapEntry.getKey()))).getKey());
            }).collect(Collectors.toList());
            logger.info("Adding ALL roles {} to user {}", (Object)StringUtils.collectionToCommaDelimitedString(rolesAsStrings), map);
        }
        return grantedAuthorities;
    }

    private Map<CoreSecurityRoles, String> prepareRoleMappings(Map<String, String> rawRoleMappings) {
        HashMap<CoreSecurityRoles, String> roleMappings = new HashMap<CoreSecurityRoles, String>(0);
        if (CollectionUtils.isEmpty(rawRoleMappings)) {
            for (CoreSecurityRoles roleEnum : CoreSecurityRoles.values()) {
                String roleName = this.oauthScopePrefix + roleEnum.getKey();
                roleMappings.put(roleEnum, roleName);
            }
            return roleMappings;
        }
        ArrayList<CoreSecurityRoles> unmappedRoles = new ArrayList<CoreSecurityRoles>(0);
        for (CoreSecurityRoles coreRole : CoreSecurityRoles.values()) {
            String coreSecurityRoleName = this.rolePrefix.length() > 0 && !coreRole.getKey().startsWith(this.rolePrefix) ? this.rolePrefix + coreRole.getKey() : coreRole.getKey();
            String oauthScope = rawRoleMappings.get(coreSecurityRoleName);
            if (oauthScope == null) {
                unmappedRoles.add(coreRole);
                continue;
            }
            roleMappings.put(coreRole, oauthScope);
        }
        if (!unmappedRoles.isEmpty()) {
            throw new IllegalArgumentException(String.format("The following %s %s not mapped: %s.", unmappedRoles.size(), unmappedRoles.size() > 1 ? "roles are" : "role is", StringUtils.collectionToDelimitedString(unmappedRoles, (String)", ")));
        }
        return roleMappings;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix cannot be null");
        this.rolePrefix = rolePrefix;
    }
}

