/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.cloud.common.security.AuthorizationProperties;
import org.springframework.cloud.common.security.ManualOAuthAuthenticationProvider;
import org.springframework.cloud.common.security.support.DataflowPrincipalExtractor;
import org.springframework.cloud.common.security.support.DefaultAuthoritiesExtractor;
import org.springframework.cloud.common.security.support.ExternalOauth2ResourceAuthoritiesExtractor;
import org.springframework.cloud.common.security.support.OnOAuth2SecurityEnabled;
import org.springframework.cloud.common.security.support.SecurityConfigUtils;
import org.springframework.cloud.common.security.support.SecurityStateBean;
import org.springframework.cloud.common.security.support.TokenValidatingUserInfoTokenServices;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.filter.OAuth2AuthenticationFailureEvent;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.resource.BaseOAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationManager;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationProcessingFilter;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.InMemoryTokenStore;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

@EnableOAuth2Client
@Configuration
@ConditionalOnClass(value={WebSecurityConfigurerAdapter.class})
@ConditionalOnMissingBean(value={WebSecurityConfigurerAdapter.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.ANY)
@EnableWebSecurity
@Conditional(value={OnOAuth2SecurityEnabled.class})
public class OAuthSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(OAuthSecurityConfiguration.class);
    @Autowired
    protected SecurityStateBean securityStateBean;
    @Autowired
    protected SecurityProperties securityProperties;
    @Autowired
    protected OAuth2ClientContext oauth2ClientContext;
    @Autowired
    protected AuthorizationCodeResourceDetails authorizationCodeResourceDetails;
    @Autowired
    protected ResourceServerProperties resourceServerProperties;
    @Autowired
    protected ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    protected AuthorizationProperties authorizationProperties;
    @Autowired
    protected BaseOAuth2ProtectedResourceDetails clientCredentialsResourceDetails;
    @Autowired(required=false)
    private PrincipalExtractor principalExtractor;

    protected void configure(HttpSecurity http) throws Exception {
        MediaTypeRequestMatcher textHtmlMatcher = new MediaTypeRequestMatcher((ContentNegotiationStrategy)new BrowserDetectingContentNegotiationStrategy(), new MediaType[]{MediaType.TEXT_HTML});
        BasicAuthenticationEntryPoint basicAuthenticationEntryPoint = new BasicAuthenticationEntryPoint();
        basicAuthenticationEntryPoint.setRealmName("Spring");
        basicAuthenticationEntryPoint.afterPropertiesSet();
        Filter oauthFilter = this.oauthFilter();
        BasicAuthenticationFilter basicAuthenticationFilter = new BasicAuthenticationFilter((AuthenticationManager)this.providerManager(), (AuthenticationEntryPoint)basicAuthenticationEntryPoint);
        http.addFilterAfter(oauthFilter, basicAuthenticationFilter.getClass());
        http.addFilterBefore((Filter)basicAuthenticationFilter, oauthFilter.getClass());
        http.addFilterBefore((Filter)this.oAuth2AuthenticationProcessingFilter(), basicAuthenticationFilter.getClass());
        this.authorizationProperties.getAuthenticatedPaths().add("/");
        this.authorizationProperties.getAuthenticatedPaths().add(this.dashboard("/**"));
        this.authorizationProperties.getAuthenticatedPaths().add(this.authorizationProperties.getDashboardUrl());
        this.authorizationProperties.getPermitAllPaths().add(this.authorizationProperties.getDashboardUrl());
        this.authorizationProperties.getPermitAllPaths().add(this.dashboard("/**"));
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry security = ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.authorizationProperties.getPermitAllPaths().toArray(new String[0]))).permitAll().antMatchers(this.authorizationProperties.getAuthenticatedPaths().toArray(new String[0]))).authenticated();
        security = SecurityConfigUtils.configureSimpleSecurity(security, this.authorizationProperties);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)security.anyRequest()).denyAll();
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.httpBasic().and()).logout().logoutSuccessUrl(this.dashboard("/logout-success-oauth.html")).and()).csrf().disable()).exceptionHandling().defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(this.authorizationProperties.getLoginProcessingUrl()), (RequestMatcher)textHtmlMatcher).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)basicAuthenticationEntryPoint, AnyRequestMatcher.INSTANCE);
        this.securityStateBean.setAuthenticationEnabled(true);
    }

    @Bean
    protected TokenValidatingUserInfoTokenServices resourceServerTokenServices() {
        TokenValidatingUserInfoTokenServices tokenServices = new TokenValidatingUserInfoTokenServices(this.resourceServerProperties.getUserInfoUri(), this.resourceServerProperties.getTokenInfoUri(), this.authorizationCodeResourceDetails.getClientId(), this.authorizationCodeResourceDetails.getClientSecret());
        tokenServices.setTokenStore((TokenStore)new InMemoryTokenStore());
        tokenServices.setSupportRefreshToken(true);
        tokenServices.setRestTemplate((OAuth2RestOperations)this.oAuth2RestTemplate());
        Object authoritiesExtractor = StringUtils.isEmpty((Object)this.authorizationProperties.getExternalAuthoritiesUrl()) ? new DefaultAuthoritiesExtractor(this.authorizationProperties.isMapOauthScopes(), this.authorizationProperties.getRoleMappings(), (OAuth2RestOperations)this.oAuth2RestTemplate()) : new ExternalOauth2ResourceAuthoritiesExtractor(this.oAuth2RestTemplate(), URI.create(this.authorizationProperties.getExternalAuthoritiesUrl()));
        tokenServices.setAuthoritiesExtractor((AuthoritiesExtractor)authoritiesExtractor);
        if (this.principalExtractor == null) {
            tokenServices.setPrincipalExtractor(new DataflowPrincipalExtractor());
        } else {
            tokenServices.setPrincipalExtractor(this.principalExtractor);
        }
        return tokenServices;
    }

    @Bean
    protected OAuth2RestTemplate oAuth2RestTemplate() {
        OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)this.authorizationCodeResourceDetails, this.oauth2ClientContext);
        return oAuth2RestTemplate;
    }

    public AccessTokenProvider userAccessTokenProvider() {
        ResourceOwnerPasswordAccessTokenProvider accessTokenProvider = new ResourceOwnerPasswordAccessTokenProvider();
        return accessTokenProvider;
    }

    @Bean
    protected AuthenticationProvider authenticationProvider() {
        return new ManualOAuthAuthenticationProvider((ResourceServerTokenServices)this.resourceServerTokenServices(), this.oauth2ClientContext);
    }

    @Bean
    protected ProviderManager providerManager() {
        ArrayList<AuthenticationProvider> providers = new ArrayList<AuthenticationProvider>();
        providers.add(this.authenticationProvider());
        ProviderManager providerManager = new ProviderManager(providers);
        return providerManager;
    }

    protected Filter oauthFilter() {
        OAuth2ClientAuthenticationProcessingFilter oauthFilter = new OAuth2ClientAuthenticationProcessingFilter("/login");
        oauthFilter.setRestTemplate((OAuth2RestOperations)this.oAuth2RestTemplate());
        oauthFilter.setTokenServices((ResourceServerTokenServices)this.resourceServerTokenServices());
        oauthFilter.setApplicationEventPublisher(this.applicationEventPublisher);
        return oauthFilter;
    }

    protected OAuth2AuthenticationProcessingFilter oAuth2AuthenticationProcessingFilter() {
        OAuth2AuthenticationProcessingFilter oAuth2AuthenticationProcessingFilter = new OAuth2AuthenticationProcessingFilter();
        oAuth2AuthenticationProcessingFilter.setAuthenticationManager(this.oauthAuthenticationManager());
        oAuth2AuthenticationProcessingFilter.setStateless(false);
        return oAuth2AuthenticationProcessingFilter;
    }

    @Bean
    public AuthenticationManager oauthAuthenticationManager() {
        OAuth2AuthenticationManager oauthAuthenticationManager = new OAuth2AuthenticationManager();
        oauthAuthenticationManager.setTokenServices((ResourceServerTokenServices)this.resourceServerTokenServices());
        return oauthAuthenticationManager;
    }

    @EventListener
    public void handleOAuth2AuthenticationFailureEvent(OAuth2AuthenticationFailureEvent oAuth2AuthenticationFailureEvent) {
        logger.error("An error occurred while accessing an authentication REST resource.", (Throwable)oAuth2AuthenticationFailureEvent.getException());
    }

    protected String dashboard(String path) {
        return this.authorizationProperties.getDashboardUrl() + path;
    }

    @Configuration
    protected static class ResourceServerConfiguration
    extends ResourceServerConfigurerAdapter {
        @Autowired
        ResourceServerTokenServices resourceServerTokenServices;

        protected ResourceServerConfiguration() {
        }

        public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
            super.configure(resources);
            resources.tokenServices(this.resourceServerTokenServices);
        }
    }

    protected static class BrowserDetectingContentNegotiationStrategy
    extends HeaderContentNegotiationStrategy {
        protected BrowserDetectingContentNegotiationStrategy() {
        }

        public List<MediaType> resolveMediaTypes(NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
            List supportedMediaTypes = super.resolveMediaTypes(request);
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null && userAgent.contains("Mozilla/5.0") && !supportedMediaTypes.contains(MediaType.APPLICATION_JSON)) {
                return Collections.singletonList(MediaType.TEXT_HTML);
            }
            return Collections.singletonList(MediaType.APPLICATION_JSON);
        }
    }
}

