/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.environment;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class VcapServiceCredentialsEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    static final Bindable<Map<String, Object>> STRING_OBJECT_MAP = Bindable.mapOf(String.class, Object.class);
    private int order = -2147483637;

    public int getOrder() {
        return this.order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Binder.get((Environment)environment).bind("vcap.services", STRING_OBJECT_MAP).orElseGet(Collections::emptyMap);
        if (!this.hasChildProperties(environment, "vcap.services")) {
            return;
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        String serviceId = this.hasChildProperties(environment, "security.oauth2.resource") ? environment.getProperty("security.oauth2.resource.service-id", "resource") : environment.getProperty("security.oauth2.sso.service-id", "sso");
        String authDomain = environment.getProperty("vcap.services." + serviceId + ".credentials.auth-domain");
        if (authDomain != null) {
            source.put("security.oauth2.resource.user-info-uri", authDomain + "/userinfo");
            source.put("security.oauth2.resource.jwt.key-uri", authDomain + "/token_key");
            source.put("security.oauth2.client.access-token-uri", authDomain + "/oauth/token");
            source.put("security.oauth2.client.user-authorization-uri", authDomain + "/oauth/authorize");
        } else {
            this.addProperty(source, (PropertyResolver)environment, serviceId, "resource", "user-info-uri", new String[0]);
            this.addProperty(source, (PropertyResolver)environment, serviceId, "resource", "token-info-uri", new String[0]);
            this.addProperty(source, (PropertyResolver)environment, serviceId, "resource.jwt", "key-uri", new String[0]);
            this.addProperty(source, (PropertyResolver)environment, serviceId, "resource", "key-value", new String[0]);
            this.addProperty(source, (PropertyResolver)environment, serviceId, "client", "access-token-uri", "token-uri");
            this.addProperty(source, (PropertyResolver)environment, serviceId, "client", "user-authorization-uri", "authorization-uri");
        }
        this.addProperty(source, (PropertyResolver)environment, serviceId, "client", "client-id", new String[0]);
        this.addProperty(source, (PropertyResolver)environment, serviceId, "client", "client-secret", new String[0]);
        this.addProperty(source, (PropertyResolver)environment, serviceId, "client", "scope", new String[0]);
        String resourceId = environment.getProperty("vcap.services." + serviceId + ".credentials.id", "");
        if (StringUtils.hasText((String)resourceId)) {
            source.put("security.oauth2.resource.id", resourceId);
        }
        environment.getPropertySources().addLast((PropertySource)new MapPropertySource("cloudDefaultSecurityBindings", source));
    }

    private boolean hasChildProperties(ConfigurableEnvironment environment, String name) {
        Map properties = (Map)Binder.get((Environment)environment).bind(name, STRING_OBJECT_MAP).orElseGet(Collections::emptyMap);
        return !properties.isEmpty();
    }

    private void addProperty(Map<String, Object> source, PropertyResolver resolver, String serviceId, String stem, String key, String ... altKeys) {
        String value = this.resolve(resolver, serviceId, key);
        if (StringUtils.hasText((String)value)) {
            source.put("security.oauth2." + stem + "." + key, value);
            return;
        }
        for (String altKey : altKeys) {
            value = this.resolve(resolver, serviceId, altKey);
            if (!StringUtils.hasText((String)value)) continue;
            source.put("security.oauth2." + stem + "." + key, value);
            return;
        }
    }

    private String resolve(PropertyResolver resolver, String serviceId, String key) {
        return resolver.getProperty(String.format("vcap.services.%s.credentials.%s", serviceId, key), "");
    }
}

