/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuple2;

public class CloudFoundryService {
    private final CloudFoundryOperations cloudFoundryOperations;

    public CloudFoundryService(CloudFoundryOperations cloudFoundryOperations) {
        this.cloudFoundryOperations = cloudFoundryOperations;
    }

    public Flux<Tuple2<ApplicationDetail, InstanceDetail>> getApplicationInstances(String serviceId) {
        GetApplicationRequest applicationRequest = GetApplicationRequest.builder().name(serviceId).build();
        return this.cloudFoundryOperations.applications().get(applicationRequest).flatMapMany(applicationDetail -> {
            Flux ids = Flux.fromStream(applicationDetail.getInstanceDetails().stream()).filter(id -> id.getState().equalsIgnoreCase("RUNNING"));
            Flux generate = Flux.generate(sink -> sink.next(applicationDetail));
            return generate.zipWith((Publisher)ids);
        });
    }
}

