/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.springframework.boot.cli.compiler.GenericBomAstTransformation;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

@GroovyASTTransformation(phase=CompilePhase.CONVERSION)
public class SpringCloudBomAstTransformation
extends GenericBomAstTransformation {
    protected String getBomModule() {
        return "org.springframework.cloud:spring-cloud-starter-parent:" + this.getBomVersion();
    }

    public int getOrder() {
        return -2147483598;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getBomVersion() {
        try (InputStream in = new ClassPathResource("META-INF/springcloudbom-version.txt").getInputStream();){
            String version = StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.hasText((String)version)) {
                version = version.trim();
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
            return null;
        }
    }
}

