/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.command.encrypt;

import java.util.Arrays;
import java.util.Collection;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.cloud.cli.command.encrypt.BaseEncryptOptionHandler;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.StringUtils;

public class EncryptCommand
extends OptionParsingCommand {
    public EncryptCommand() {
        super("encrypt", "Encrypt a string so, for instance, it can be added to source control", (OptionHandler)new EncryptOptionHandler());
    }

    public String getUsageHelp() {
        return "[options] <text>";
    }

    private static class EncryptOptionHandler
    extends BaseEncryptOptionHandler {
        private OptionSpec<String> propertyOption;

        private EncryptOptionHandler() {
        }

        @Override
        protected void doOptions() {
            this.propertyOption = this.option(Arrays.asList("property", "p"), "A name for the encrypted value. Output will be in a form that can be pasted in to a properties file.").withRequiredArg();
        }

        protected synchronized ExitStatus run(OptionSet options) throws Exception {
            TextEncryptor encryptor = this.createEncryptor(options);
            String text = StringUtils.collectionToDelimitedString((Collection)options.nonOptionArguments(), (String)" ");
            System.out.println(this.formatCipher(options, encryptor.encrypt(text)));
            return ExitStatus.OK;
        }

        protected String formatCipher(OptionSet options, String output) {
            if (options.has(this.propertyOption)) {
                output = ((String)options.valueOf(this.propertyOption)).replace(":", "\\:").replace("=", "\\=").replace(" ", "\\ ") + "={cipher}" + output;
            }
            return output;
        }
    }
}

