/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetricsPublisher;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreakerFactory;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4jBulkheadProvider;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigurationProperties;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux", "io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator"})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.resilience4j.enabled", "spring.cloud.circuitbreaker.resilience4j.reactive.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={Resilience4JConfigurationProperties.class})
public class ReactiveResilience4JAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<ReactiveResilience4JCircuitBreakerFactory>> customizers = new ArrayList<Customizer<ReactiveResilience4JCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={ReactiveCircuitBreakerFactory.class})
    public ReactiveResilience4JCircuitBreakerFactory reactiveResilience4JCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, @Autowired(required=false) ReactiveResilience4jBulkheadProvider bulkheadProvider, Resilience4JConfigurationProperties resilience4JConfigurationProperties) {
        ReactiveResilience4JCircuitBreakerFactory factory = new ReactiveResilience4JCircuitBreakerFactory(circuitBreakerRegistry, timeLimiterRegistry, bulkheadProvider, resilience4JConfigurationProperties);
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux", "io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics", "io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetricsPublisher"})
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnMissingBean(value={TaggedCircuitBreakerMetricsPublisher.class})
    public static class MicrometerReactiveResilience4JCustomizerConfiguration {
        @Autowired(required=false)
        private ReactiveResilience4JCircuitBreakerFactory factory;
        @Autowired(required=false)
        private ReactiveResilience4jBulkheadProvider bulkheadProvider;
        @Autowired(required=false)
        private TaggedCircuitBreakerMetrics taggedCircuitBreakerMetrics;
        @Autowired
        private MeterRegistry meterRegistry;

        @PostConstruct
        public void init() {
            if (this.factory != null) {
                if (this.taggedCircuitBreakerMetrics == null) {
                    this.taggedCircuitBreakerMetrics = TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)this.factory.getCircuitBreakerRegistry());
                }
                this.taggedCircuitBreakerMetrics.bindTo(this.meterRegistry);
            }
            if (this.bulkheadProvider != null) {
                TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)this.bulkheadProvider.getBulkheadRegistry()).bindTo(this.meterRegistry);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Bulkhead.class})
    @ConditionalOnProperty(value={"spring.cloud.circuitbreaker.bulkhead.resilience4j.enabled"}, matchIfMissing=true)
    public static class Resilience4jBulkheadConfiguration {
        @Autowired(required=false)
        private List<Customizer<ReactiveResilience4jBulkheadProvider>> bulkheadCustomizers = new ArrayList<Customizer<ReactiveResilience4jBulkheadProvider>>();
        @Value(value="${spring.cloud.circuitbreaker.resilience4j.enableSemaphoreDefaultBulkhead:true}")
        private boolean enableSemaphoreDefaultBulkhead;

        @Bean
        public ReactiveResilience4jBulkheadProvider reactiveBulkheadProvider(BulkheadRegistry bulkheadRegistry) {
            if (!this.enableSemaphoreDefaultBulkhead) {
                LoggerFactory.getLogger(Resilience4jBulkheadConfiguration.class).warn("Ignoring 'spring.cloud.circuitbreaker.resilience4j.enableSemaphoreDefaultBulkhead=false'. ReactiveResilience4jBulkheadProvider only supports SemaphoreBulkhead.");
            }
            ReactiveResilience4jBulkheadProvider reactiveResilience4JCircuitBreaker = new ReactiveResilience4jBulkheadProvider(bulkheadRegistry);
            this.bulkheadCustomizers.forEach(customizer -> customizer.customize((Object)reactiveResilience4JCircuitBreaker));
            return reactiveResilience4JCircuitBreaker;
        }
    }
}

