/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.trace.http.HttpTraceRepository;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.LifecycleMvcEndpointAutoConfiguration;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.ServiceMatcherAutoConfiguration;
import org.springframework.cloud.bus.SpringCloudBusClient;
import org.springframework.cloud.bus.endpoint.EnvironmentBusEndpoint;
import org.springframework.cloud.bus.event.AckRemoteApplicationEvent;
import org.springframework.cloud.bus.event.EnvironmentChangeListener;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.bus.event.SentApplicationEvent;
import org.springframework.cloud.bus.event.TraceListener;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBusEnabled
@EnableBinding(value={SpringCloudBusClient.class})
@EnableConfigurationProperties(value={BusProperties.class})
@AutoConfigureBefore(value={BindingServiceConfiguration.class})
@AutoConfigureAfter(value={LifecycleMvcEndpointAutoConfiguration.class, ServiceMatcherAutoConfiguration.class})
public class BusAutoConfiguration
implements ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog(BusAutoConfiguration.class);
    public static final String BUS_PATH_MATCHER_NAME = "busPathMatcher";
    public static final String CLOUD_CONFIG_NAME_PROPERTY = "spring.cloud.config.name";
    private final ServiceMatcher serviceMatcher;
    private final BindingServiceProperties bindings;
    private final BusProperties bus;
    private MessageChannel cloudBusOutboundChannel;
    private ApplicationEventPublisher applicationEventPublisher;

    public BusAutoConfiguration(ServiceMatcher serviceMatcher, BindingServiceProperties bindings, BusProperties bus) {
        this.serviceMatcher = serviceMatcher;
        this.bindings = bindings;
        this.bus = bus;
    }

    @PostConstruct
    public void init() {
        BindingProperties output;
        BindingProperties outputBinding;
        BindingProperties input;
        BindingProperties inputBinding = (BindingProperties)this.bindings.getBindings().get("springCloudBusInput");
        if (inputBinding == null) {
            this.bindings.getBindings().put("springCloudBusInput", new BindingProperties());
        }
        if ((input = (BindingProperties)this.bindings.getBindings().get("springCloudBusInput")).getDestination() == null || input.getDestination().equals("springCloudBusInput")) {
            input.setDestination(this.bus.getDestination());
        }
        if ((outputBinding = (BindingProperties)this.bindings.getBindings().get("springCloudBusOutput")) == null) {
            this.bindings.getBindings().put("springCloudBusOutput", new BindingProperties());
        }
        if ((output = (BindingProperties)this.bindings.getBindings().get("springCloudBusOutput")).getDestination() == null || output.getDestination().equals("springCloudBusOutput")) {
            output.setDestination(this.bus.getDestination());
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Autowired
    @Output(value="springCloudBusOutput")
    public void setCloudBusOutboundChannel(MessageChannel cloudBusOutboundChannel) {
        this.cloudBusOutboundChannel = cloudBusOutboundChannel;
    }

    @EventListener(classes={RemoteApplicationEvent.class})
    public void acceptLocal(RemoteApplicationEvent event) {
        if (this.serviceMatcher.isFromSelf(event) && !(event instanceof AckRemoteApplicationEvent)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending remote event on bus: " + (Object)((Object)event)));
            }
            this.cloudBusOutboundChannel.send(MessageBuilder.withPayload((Object)((Object)event)).build());
        }
    }

    @StreamListener(value="springCloudBusInput")
    public void acceptRemote(RemoteApplicationEvent event) {
        if (event instanceof AckRemoteApplicationEvent) {
            if (this.bus.getTrace().isEnabled() && !this.serviceMatcher.isFromSelf(event) && this.applicationEventPublisher != null) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received remote event from bus: " + (Object)((Object)event)));
        }
        if (this.serviceMatcher.isForSelf(event) && this.applicationEventPublisher != null) {
            if (!this.serviceMatcher.isFromSelf(event)) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
            }
            if (this.bus.getAck().isEnabled()) {
                AckRemoteApplicationEvent ack = new AckRemoteApplicationEvent(this, this.serviceMatcher.getServiceId(), this.bus.getAck().getDestinationService(), event.getDestinationService(), event.getId(), ((Object)((Object)event)).getClass());
                this.cloudBusOutboundChannel.send(MessageBuilder.withPayload((Object)((Object)ack)).build());
                this.applicationEventPublisher.publishEvent((ApplicationEvent)ack);
            }
        }
        if (this.bus.getTrace().isEnabled() && this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new SentApplicationEvent(this, event.getOriginService(), event.getDestinationService(), event.getId(), ((Object)((Object)event)).getClass()));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EnvironmentManager.class})
    @ConditionalOnBean(value={EnvironmentManager.class})
    protected static class BusEnvironmentConfiguration {
        protected BusEnvironmentConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.bus.env.enabled"}, matchIfMissing=true)
        public EnvironmentChangeListener environmentChangeListener() {
            return new EnvironmentChangeListener();
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={Endpoint.class})
        protected static class EnvironmentBusEndpointConfiguration {
            protected EnvironmentBusEndpointConfiguration() {
            }

            @Bean
            @ConditionalOnAvailableEndpoint
            public EnvironmentBusEndpoint environmentBusEndpoint(ApplicationContext context, BusProperties bus) {
                return new EnvironmentBusEndpoint((ApplicationEventPublisher)context, bus.getId());
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Endpoint.class})
    @ConditionalOnBean(value={HttpTraceRepository.class})
    @ConditionalOnProperty(value={"spring.cloud.bus.trace.enabled"}, matchIfMissing=false)
    protected static class BusAckTraceConfiguration {
        protected BusAckTraceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TraceListener ackTraceListener(HttpTraceRepository repository) {
            return new TraceListener(repository);
        }
    }
}

