/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.cloud.bus.BusAutoConfiguration;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.endpoint.RefreshBusEndpoint;
import org.springframework.cloud.bus.jackson.BusJacksonMessageConverter;
import org.springframework.cloud.stream.annotation.StreamMessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.AbstractMessageConverter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBusEnabled
@ConditionalOnClass(value={RefreshBusEndpoint.class, ObjectMapper.class})
@AutoConfigureBefore(value={BusAutoConfiguration.class, JacksonAutoConfiguration.class})
public class BusJacksonAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"busJsonConverter"})
    @StreamMessageConverter
    public AbstractMessageConverter busJsonConverter(@Autowired(required=false) ObjectMapper objectMapper) {
        return new BusJacksonMessageConverter(objectMapper);
    }
}

