/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.util.PathMatcher;

public class ServiceMatcher {
    private final PathMatcher matcher;
    private final String id;

    public ServiceMatcher(PathMatcher matcher, String id) {
        this.matcher = matcher;
        this.id = id;
    }

    public boolean isFromSelf(RemoteApplicationEvent event) {
        String originService = event.getOriginService();
        String serviceId = this.getServiceId();
        return this.matcher.match(originService, serviceId);
    }

    public boolean isForSelf(RemoteApplicationEvent event) {
        String destinationService = event.getDestinationService();
        return destinationService == null || destinationService.trim().isEmpty() || this.matcher.match(destinationService, this.getServiceId());
    }

    public String getServiceId() {
        return this.id;
    }
}

