/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.cloud.bindings.boot.pem.PemSslStoreHelper;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

final class EurekaBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "eureka";

    EurekaBindingsPropertiesProcessor() {
    }

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            String caCert;
            Map<String, String> secret = binding.getSecret();
            MapMapper map = new MapMapper(secret, properties);
            map.from("client-id").to("eureka.client.oauth2.client-id");
            map.from("access-token-uri").to("eureka.client.oauth2.access-token-uri");
            map.from("uri").to("eureka.client.serviceUrl.defaultZone", uri -> String.format("%s/eureka/", uri));
            map.from("uri").to("eureka.instance.metadata-map.zone", this::hostnameFromUri);
            properties.put("eureka.client.region", "default");
            properties.put("spring.cloud.loadbalancer.configurations", "zone-preference");
            if (this.isKubernetesPlatform(environment) && !environment.containsProperty("eureka.instance.preferIpAddress")) {
                properties.put("eureka.instance.preferIpAddress", true);
            }
            if ((caCert = secret.get("ca.crt")) != null && !caCert.isEmpty()) {
                String generatedPassword = PemSslStoreHelper.generatePassword();
                Path trustFilePath = PemSslStoreHelper.createKeyStoreFile("eureka-truststore", generatedPassword, caCert, null, "rootca");
                properties.put("eureka.client.tls.enabled", true);
                properties.put("eureka.client.tls.trust-store", "file:" + trustFilePath);
                properties.put("eureka.client.tls.trust-store-type", "PKCS12");
                properties.put("eureka.client.tls.trust-store-password", generatedPassword);
                String clientKey = secret.get("tls.key");
                String clientCert = secret.get("tls.crt");
                if (StringUtils.hasText((String)clientCert) != StringUtils.hasText((String)clientKey)) {
                    throw new IllegalArgumentException("binding secret error: tls.key and tls.crt must both be set if either is set");
                }
                if (clientKey != null && !clientKey.isEmpty()) {
                    Path keyFilePath = PemSslStoreHelper.createKeyStoreFile("eureka-keystore", generatedPassword, clientCert, clientKey, TYPE);
                    properties.put("eureka.client.tls.key-alias", TYPE);
                    properties.put("eureka.client.tls.key-store", "file:" + keyFilePath);
                    properties.put("eureka.client.tls.key-store-type", "PKCS12");
                    properties.put("eureka.client.tls.key-store-password", generatedPassword);
                    properties.put("eureka.client.tls.key-password", "");
                }
            }
        });
    }

    private boolean isKubernetesPlatform(Environment environment) {
        return CloudPlatform.KUBERNETES == CloudPlatform.getActive((Environment)environment);
    }

    private String hostnameFromUri(String uri) {
        if (!StringUtils.hasText((String)uri)) {
            return "";
        }
        try {
            URI u = URI.create(uri);
            if (u.getHost() != null) {
                return u.getHost();
            }
            if (u.getScheme() == null) {
                return URI.create("ignore://" + uri).getHost();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "";
    }
}

