/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

final class KafkaBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "kafka";

    KafkaBindingsPropertiesProcessor() {
    }

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("bootstrap-servers").to("spring.kafka.bootstrap-servers");
            map.from("consumer.bootstrap-servers").to("spring.kafka.consumer.bootstrap-servers");
            map.from("producer.bootstrap-servers").to("spring.kafka.producer.bootstrap-servers");
            map.from("streams.bootstrap-servers").to("spring.kafka.streams.bootstrap-servers");
        });
    }
}

