/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

public final class WavefrontBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "wavefront";

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("api-token").to("management.metrics.export.wavefront.api-token");
            map.from("uri").to("management.metrics.export.wavefront.uri");
        });
    }
}

