/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.secretsmanager;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.amazonaws.services.secretsmanager.model.ResourceNotFoundException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.EnumerablePropertySource;

public class AwsSecretsManagerPropertySource
extends EnumerablePropertySource<AWSSecretsManager> {
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private String context;
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public AwsSecretsManagerPropertySource(String context, AWSSecretsManager smClient) {
        super(context, (Object)smClient);
        this.context = context;
    }

    public void init() {
        GetSecretValueRequest secretValueRequest = new GetSecretValueRequest();
        secretValueRequest.setSecretId(this.context);
        this.readSecretValue(secretValueRequest);
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void readSecretValue(GetSecretValueRequest secretValueRequest) {
        try {
            GetSecretValueResult secretValueResult = ((AWSSecretsManager)this.source).getSecretValue(secretValueRequest);
            Map secretMap = (Map)this.jsonMapper.readValue(secretValueResult.getSecretString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            for (Map.Entry secretEntry : secretMap.entrySet()) {
                this.properties.put((String)secretEntry.getKey(), secretEntry.getValue());
            }
        }
        catch (ResourceNotFoundException e) {
            this.logger.debug((Object)("AWS secret not found from " + secretValueRequest.getSecretId()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

