/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.endpoint;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.cloud.aws.messaging.config.annotation.NotificationSubject;
import org.springframework.cloud.aws.messaging.endpoint.AbstractNotificationMessageHandlerMethodArgumentResolver;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.util.ClassUtils;

public class NotificationSubjectHandlerMethodArgumentResolver
extends AbstractNotificationMessageHandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(NotificationSubject.class) && ClassUtils.isAssignable(String.class, (Class)parameter.getParameterType());
    }

    @Override
    protected Object doResolveArgumentFromNotificationMessage(JsonNode content, HttpInputMessage request, Class<?> parameterType) {
        if (!"Notification".equals(content.get("Type").asText())) {
            throw new IllegalArgumentException("@NotificationMessage annotated parameters are only allowed for method that receive a notification message.");
        }
        return content.findPath("Subject").asText();
    }
}

