/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.jdbc.datasource.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.springframework.cloud.aws.jdbc.datasource.support.DatabasePlatformSupport;
import org.springframework.cloud.aws.jdbc.datasource.support.DatabaseType;
import org.springframework.util.Assert;

public abstract class MapBasedDatabasePlatformSupport
implements DatabasePlatformSupport {
    @Override
    public String getDriverClassNameForDatabase(DatabaseType databaseType) {
        Assert.notNull((Object)((Object)databaseType), (String)"databaseType must not be null");
        String candidate = this.getDriverClassNameMappings().get((Object)databaseType);
        Assert.notNull((Object)candidate, (String)String.format("No driver class name found for database :'%s'", databaseType.name()));
        return candidate;
    }

    @Override
    public String getDatabaseUrlForDatabase(DatabaseType databaseType, String hostname, int port, String databaseName) {
        String scheme = this.getSchemeNames().get((Object)databaseType);
        String authenticationInfo = this.getAuthenticationInfo().get((Object)databaseType);
        Assert.notNull((Object)((Object)databaseType), (String)String.format("No scheme name found for database :'%s'", databaseType.name()));
        try {
            return new URI(scheme, authenticationInfo, hostname, port, databaseName != null ? "/" + databaseName : null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error constructing URI from Host:'" + hostname + "' and port:'" + port + "' and database name:'" + databaseName + "'!");
        }
    }

    protected abstract Map<DatabaseType, String> getDriverClassNameMappings();

    protected abstract Map<DatabaseType, String> getSchemeNames();

    protected abstract Map<DatabaseType, String> getAuthenticationInfo();
}

