/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.config.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.aws.context.config.xml.GlobalBeanDefinitionUtils;
import org.springframework.cloud.aws.core.config.xml.XmlWebserviceConfigurationUtils;
import org.springframework.cloud.aws.core.env.stack.config.StackResourceUserTagsFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class StackConfigurationBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String STACK_RESOURCE_REGISTRY_FACTORY_BEAN_CLASS_NAME = "org.springframework.cloud.aws.core.env.stack.config.StackResourceRegistryFactoryBean";
    private static final String STATIC_STACK_NAME_PROVIDER_CLASS_NAME = "org.springframework.cloud.aws.core.env.stack.config.StaticStackNameProvider";
    private static final String AUTO_DETECTING_STACK_NAME_PROVIDER_CLASS_NAME = "org.springframework.cloud.aws.core.env.stack.config.AutoDetectingStackNameProvider";
    private static final String INSTANCE_ID_PROVIDER_CLASS_NAME = "org.springframework.cloud.aws.core.env.ec2.AmazonEc2InstanceIdProvider";
    private static final String CLOUD_FORMATION_CLIENT_CLASS_NAME = "com.amazonaws.services.cloudformation.AmazonCloudFormationClient";
    private static final String EC2_CLIENT_CLASS_NAME = "com.amazonaws.services.ec2.AmazonEC2Client";
    private static final String STACK_NAME_ATTRIBUTE_NAME = "stack-name";

    StackConfigurationBeanDefinitionParser() {
    }

    private static AbstractBeanDefinition buildStaticStackNameProviderBeanDefinition(String stackName) {
        BeanDefinitionBuilder staticStackNameProviderBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)STATIC_STACK_NAME_PROVIDER_CLASS_NAME);
        staticStackNameProviderBeanDefinitionBuilder.addConstructorArgValue((Object)stackName);
        return staticStackNameProviderBeanDefinitionBuilder.getBeanDefinition();
    }

    private static AbstractBeanDefinition buildAutoDetectingStackNameProviderBeanDefinition(String amazonCloudFormationClientBeanName, String amazonEc2ClientBeanName) {
        BeanDefinitionBuilder autoDetectingStackNameProviderBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)AUTO_DETECTING_STACK_NAME_PROVIDER_CLASS_NAME);
        autoDetectingStackNameProviderBeanDefinitionBuilder.addConstructorArgReference(amazonCloudFormationClientBeanName);
        autoDetectingStackNameProviderBeanDefinitionBuilder.addConstructorArgReference(amazonEc2ClientBeanName);
        autoDetectingStackNameProviderBeanDefinitionBuilder.addConstructorArgValue((Object)StackConfigurationBeanDefinitionParser.buildInstanceIdProviderBeanDefinition());
        return autoDetectingStackNameProviderBeanDefinitionBuilder.getBeanDefinition();
    }

    private static AbstractBeanDefinition buildInstanceIdProviderBeanDefinition() {
        BeanDefinitionBuilder instanceIdProviderBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)INSTANCE_ID_PROVIDER_CLASS_NAME);
        return instanceIdProviderBeanDefinitionBuilder.getBeanDefinition();
    }

    private static void buildAndRegisterStackUserTagsIfNeeded(Element element, ParserContext parserContext, String cloudformationBeanName, BeanDefinition stackNameProvider) {
        if (StringUtils.hasText((String)element.getAttribute("user-tags-map"))) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StackResourceUserTagsFactoryBean.class);
            builder.addConstructorArgReference(cloudformationBeanName);
            builder.addConstructorArgValue((Object)stackNameProvider);
            parserContext.getRegistry().registerBeanDefinition(element.getAttribute("user-tags-map"), (BeanDefinition)builder.getBeanDefinition());
        }
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        GlobalBeanDefinitionUtils.registerResourceIdResolverBeanIfNeeded(parserContext.getRegistry());
        String amazonCloudFormationClientBeanName = XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)element, (ParserContext)parserContext, (String)"amazon-cloud-formation", (String)CLOUD_FORMATION_CLIENT_CLASS_NAME);
        String amazonEc2ClientBeanName = XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)element, (ParserContext)parserContext, (String)"amazon-ec2", (String)EC2_CLIENT_CLASS_NAME);
        String stackName = element.getAttribute(STACK_NAME_ATTRIBUTE_NAME);
        builder.addConstructorArgReference(amazonCloudFormationClientBeanName);
        AbstractBeanDefinition stackNameProviderBeanDefinition = StringUtils.isEmpty((Object)stackName) ? StackConfigurationBeanDefinitionParser.buildAutoDetectingStackNameProviderBeanDefinition(amazonCloudFormationClientBeanName, amazonEc2ClientBeanName) : StackConfigurationBeanDefinitionParser.buildStaticStackNameProviderBeanDefinition(stackName);
        builder.addConstructorArgValue((Object)stackNameProviderBeanDefinition);
        StackConfigurationBeanDefinitionParser.buildAndRegisterStackUserTagsIfNeeded(element, parserContext, amazonCloudFormationClientBeanName, (BeanDefinition)stackNameProviderBeanDefinition);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return element.hasAttribute(STACK_NAME_ATTRIBUTE_NAME) ? element.getAttribute(STACK_NAME_ATTRIBUTE_NAME) : parserContext.getReaderContext().generateBeanName((BeanDefinition)definition);
    }

    protected String getBeanClassName(Element element) {
        return STACK_RESOURCE_REGISTRY_FACTORY_BEAN_CLASS_NAME;
    }
}

