/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.cache.redis;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.cache.Cache;
import org.springframework.cloud.aws.cache.AbstractCacheFactory;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.util.ClassUtils;

public class RedisCacheFactory
extends AbstractCacheFactory<RedisConnectionFactory> {
    private static final boolean JEDIS_AVAILABLE = ClassUtils.isPresent((String)"redis.clients.jedis.Jedis", (ClassLoader)ClassUtils.getDefaultClassLoader());
    private static final boolean LETTUCE_AVAILABLE = ClassUtils.isPresent((String)"io.lettuce.core.RedisClient", (ClassLoader)ClassUtils.getDefaultClassLoader());

    @Override
    public boolean isSupportingCacheArchitecture(String architecture) {
        return "redis".equalsIgnoreCase(architecture);
    }

    @Override
    public Cache createCache(String cacheName, String host, int port) throws Exception {
        return RedisCacheManager.builder((RedisConnectionFactory)((RedisConnectionFactory)this.getConnectionFactory(host, port))).build().getCache(cacheName);
    }

    @Override
    protected void destroyConnectionClient(RedisConnectionFactory connectionClient) throws Exception {
        if (connectionClient instanceof DisposableBean) {
            ((DisposableBean)connectionClient).destroy();
        }
    }

    @Override
    protected RedisConnectionFactory createConnectionClient(String hostName, int port) {
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration();
        configuration.setHostName(hostName);
        configuration.setPort(port);
        if (JEDIS_AVAILABLE) {
            return new JedisConnectionFactory(configuration);
        }
        if (LETTUCE_AVAILABLE) {
            return new LettuceConnectionFactory(configuration);
        }
        throw new IllegalArgumentException("No Jedis or lettuce client on classpath. Please add one of the implementation to your classpath");
    }
}

