/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.aws.core.env.ec2.AmazonEc2InstanceDataPropertySource;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class AmazonEc2InstanceDataPropertySourcePostProcessor
implements PriorityOrdered,
EnvironmentAware,
BeanFactoryPostProcessor {
    static final String INSTANCE_DATA_PROPERTY_SOURCE_NAME = "InstanceData";
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonEc2InstanceDataPropertySourcePostProcessor.class);
    private Environment environment;
    private String valueSeparator;
    private String attributeSeparator;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public void setAttributeSeparator(String attributeSeparator) {
        this.attributeSeparator = attributeSeparator;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.environment instanceof ConfigurableEnvironment) {
            AmazonEc2InstanceDataPropertySource propertySource = new AmazonEc2InstanceDataPropertySource(INSTANCE_DATA_PROPERTY_SOURCE_NAME);
            if (StringUtils.hasText((String)this.valueSeparator)) {
                propertySource.setUserDataValueSeparator(this.valueSeparator);
            }
            if (StringUtils.hasText((String)this.attributeSeparator)) {
                propertySource.setUserDataAttributeSeparator(this.attributeSeparator);
            }
            ((ConfigurableEnvironment)this.environment).getPropertySources().addLast((PropertySource)propertySource);
        } else {
            LOGGER.warn("Environment is not of type '{}' property source with instance data is not available", (Object)ConfigurableEnvironment.class.getName());
        }
    }
}

