/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.aws.core.config.AmazonWebserviceClientConfigurationUtils;
import org.springframework.cloud.aws.jdbc.config.annotation.AmazonRdsInstanceConfiguration;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Import(value={Registrar.class})
@ConditionalOnClass(name={"com.amazonaws.services.rds.AmazonRDSClient", "org.springframework.cloud.aws.jdbc.config.annotation.AmazonRdsInstanceConfiguration"})
@ConditionalOnMissingBean(value={AmazonRdsInstanceConfiguration.class})
public class AmazonRdsDatabaseAutoConfiguration {
    @Bean
    public static AmazonRdsInstanceConfiguration.RdsInstanceConfigurerBeanPostProcessor rdsInstanceConfigurerBeanPostProcessor() {
        return new AmazonRdsInstanceConfiguration.RdsInstanceConfigurerBeanPostProcessor();
    }

    public static class Registrar
    extends AmazonRdsInstanceConfiguration.AbstractRegistrar
    implements EnvironmentAware {
        private static final String PREFIX = "cloud.aws.rds";
        private ConfigurableEnvironment environment;

        private static String extractConfigurationSubPropertyName(String propertyName) {
            if (!propertyName.contains(".")) {
                return propertyName;
            }
            return propertyName.substring(propertyName.lastIndexOf(".") + 1);
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            String amazonRdsClientBeanName = AmazonWebserviceClientConfigurationUtils.registerAmazonWebserviceClient((Object)((Object)this), (BeanDefinitionRegistry)registry, (String)"com.amazonaws.services.rds.AmazonRDSClient", null, null).getBeanName();
            Map<String, Map<String, String>> dbInstanceConfigurations = this.getDbInstanceConfigurations();
            for (Map.Entry<String, Map<String, String>> dbInstanceEntry : dbInstanceConfigurations.entrySet()) {
                this.registerDataSource(registry, amazonRdsClientBeanName, dbInstanceEntry.getKey(), dbInstanceEntry.getValue().get("password"), Boolean.valueOf(dbInstanceEntry.getValue().getOrDefault("readReplicaSupport", "false")), dbInstanceEntry.getValue().get("username"), dbInstanceEntry.getValue().get("databaseName"));
            }
        }

        public void setEnvironment(Environment environment) {
            Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment, (String)"Amazon RDS auto configuration requires a configurable environment");
            this.environment = (ConfigurableEnvironment)environment;
        }

        private Map<String, Map<String, String>> getDbInstanceConfigurations() {
            Map subProperties = (Map)Binder.get((Environment)this.environment).bind(PREFIX, Bindable.mapOf(String.class, Object.class)).orElseGet(Collections::emptyMap);
            HashMap<String, Map<String, String>> dbConfigurationMap = new HashMap<String, Map<String, String>>(subProperties.keySet().size());
            for (Map.Entry subProperty : subProperties.entrySet()) {
                String subPropertyName;
                Object value;
                String instanceName = (String)subProperty.getKey();
                if (!dbConfigurationMap.containsKey(instanceName)) {
                    dbConfigurationMap.put(instanceName, new HashMap());
                }
                if ((value = subProperty.getValue()) instanceof Map) {
                    Map map = (Map)value;
                    for (Map.Entry entry : map.entrySet()) {
                        ((Map)dbConfigurationMap.get(instanceName)).put(entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (!(value instanceof String) || !StringUtils.hasText((String)(subPropertyName = Registrar.extractConfigurationSubPropertyName((String)subProperty.getKey())))) continue;
                ((Map)dbConfigurationMap.get(instanceName)).put(subPropertyName, (String)subProperty.getValue());
            }
            return dbConfigurationMap;
        }
    }
}

