/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.consumer.log;

import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.fn.consumer.log.LogConsumerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowDefinition;
import org.springframework.integration.gateway.AnnotationGatewayProxyFactoryBean;
import org.springframework.messaging.Message;

@AutoConfiguration
@EnableConfigurationProperties(value={LogConsumerProperties.class})
public class LogConsumerConfiguration {
    @Bean
    IntegrationFlow logConsumerFlow(LogConsumerProperties logSinkProperties) {
        return flow -> ((IntegrationFlowDefinition)flow.log(logSinkProperties.getLevel(), logSinkProperties.getName(), logSinkProperties.getExpression())).nullChannel();
    }

    @Bean
    AnnotationGatewayProxyFactoryBean<Consumer<Message<?>>> logConsumer() {
        AnnotationGatewayProxyFactoryBean gatewayProxyFactoryBean = new AnnotationGatewayProxyFactoryBean(Consumer.class);
        gatewayProxyFactoryBean.setDefaultRequestChannelName("logConsumerFlow.input");
        return gatewayProxyFactoryBean;
    }
}

