/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public class JobRepositoryTestUtils
extends AbstractJdbcBatchMetadataDao
implements InitializingBean {
    private JobRepository jobRepository;
    private JobParametersIncrementer jobParametersIncrementer = new JobParametersIncrementer(){
        Long count = 0L;

        public JobParameters getNext(JobParameters parameters) {
            Long l = this.count;
            Long l2 = this.count = Long.valueOf(this.count + 1L);
            return new JobParameters(Collections.singletonMap("count", new JobParameter(l)));
        }
    };
    private JdbcOperations jdbcTemplate;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository must be set");
        Assert.notNull((Object)this.jdbcTemplate, (String)"DataSource must be set");
    }

    public JobRepositoryTestUtils() {
    }

    public JobRepositoryTestUtils(JobRepository jobRepository, DataSource dataSource) {
        this.jobRepository = jobRepository;
        this.setDataSource(dataSource);
    }

    public final void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.jobParametersIncrementer = jobParametersIncrementer;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public List<JobExecution> createJobExecutions(String jobName, String[] stepNames, int count) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        ArrayList<JobExecution> list = new ArrayList<JobExecution>();
        JobParameters jobParameters = new JobParameters();
        for (int i = 0; i < count; ++i) {
            JobExecution jobExecution = this.jobRepository.createJobExecution(jobName, this.jobParametersIncrementer.getNext(jobParameters));
            list.add(jobExecution);
            for (String stepName : stepNames) {
                this.jobRepository.add(jobExecution.createStepExecution(stepName));
            }
        }
        return list;
    }

    public List<JobExecution> createJobExecutions(int count) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        return this.createJobExecutions("job", new String[]{"step"}, count);
    }

    public void removeJobExecutions(Collection<JobExecution> list) throws DataAccessException {
        for (JobExecution jobExecution : list) {
            List stepExecutionIds = this.jdbcTemplate.query(this.getQuery("select STEP_EXECUTION_ID from %PREFIX%STEP_EXECUTION where JOB_EXECUTION_ID=?"), (RowMapper)new RowMapper<Long>(){

                public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getLong(1);
                }
            }, new Object[]{jobExecution.getId()});
            for (Long stepExecutionId : stepExecutionIds) {
                this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%STEP_EXECUTION_CONTEXT where STEP_EXECUTION_ID=?"), new Object[]{stepExecutionId});
                this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%STEP_EXECUTION where STEP_EXECUTION_ID=?"), new Object[]{stepExecutionId});
            }
            this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION_CONTEXT where JOB_EXECUTION_ID=?"), new Object[]{jobExecution.getId()});
            this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION_PARAMS where JOB_EXECUTION_ID=?"), new Object[]{jobExecution.getId()});
            this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID=?"), new Object[]{jobExecution.getId()});
        }
        for (JobExecution jobExecution : list) {
            this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_INSTANCE where JOB_INSTANCE_ID=?"), new Object[]{jobExecution.getJobId()});
        }
    }

    public void removeJobExecutions() throws DataAccessException {
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%STEP_EXECUTION_CONTEXT"));
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%STEP_EXECUTION"));
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION_CONTEXT"));
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION_PARAMS"));
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION"));
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_INSTANCE"));
    }
}

