/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.async;

import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AsyncItemProcessor<I, O>
implements ItemProcessor<I, Future<O>>,
InitializingBean {
    private ItemProcessor<I, O> delegate;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate must be set.");
    }

    public void setDelegate(ItemProcessor<I, O> delegate) {
        this.delegate = delegate;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Nullable
    public Future<O> process(I item) throws Exception {
        StepExecution stepExecution = this.getStepExecution();
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            if (stepExecution != null) {
                StepSynchronizationManager.register((StepExecution)stepExecution);
            }
            try {
                Object object = this.delegate.process(item);
                return object;
            }
            finally {
                if (stepExecution != null) {
                    StepSynchronizationManager.close();
                }
            }
        });
        this.taskExecutor.execute(task);
        return task;
    }

    private StepExecution getStepExecution() {
        StepContext context = StepSynchronizationManager.getContext();
        if (context == null) {
            return null;
        }
        StepExecution stepExecution = context.getStepExecution();
        return stepExecution;
    }
}

