/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.async;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class AsyncItemProcessor<I, O>
implements ItemProcessor<I, Future<O>>,
InitializingBean {
    private ItemProcessor<I, O> delegate;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegate, (String)"The delegate must be set.");
    }

    public void setDelegate(ItemProcessor<I, O> delegate) {
        this.delegate = delegate;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public Future<O> process(final I item) throws Exception {
        final StepExecution stepExecution = this.getStepExecution();
        FutureTask task = new FutureTask(new Callable<O>(){

            @Override
            public O call() throws Exception {
                if (stepExecution != null) {
                    StepSynchronizationManager.register((StepExecution)stepExecution);
                }
                try {
                    Object object = AsyncItemProcessor.this.delegate.process(item);
                    return object;
                }
                finally {
                    if (stepExecution != null) {
                        StepSynchronizationManager.close();
                    }
                }
            }
        });
        this.taskExecutor.execute(task);
        return task;
    }

    private StepExecution getStepExecution() {
        StepContext context = StepSynchronizationManager.getContext();
        if (context == null) {
            return null;
        }
        StepExecution stepExecution = context.getStepExecution();
        return stepExecution;
    }
}

