/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.channel.interceptor.ChannelInterceptorAdapter;
import org.springframework.integration.core.MessageSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSourcePollerInterceptor
extends ChannelInterceptorAdapter
implements InitializingBean {
    private static Log logger = LogFactory.getLog(MessageSourcePollerInterceptor.class);
    private MessageSource<?> source;
    private MessageChannel channel;

    public MessageSourcePollerInterceptor() {
    }

    public MessageSourcePollerInterceptor(MessageSource<?> source) {
        this.source = source;
    }

    public void setChannel(MessageChannel channel) {
        this.channel = channel;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.source != null ? 1 : 0) != 0, (String)"A MessageSource must be provided");
    }

    public void setMessageSource(MessageSource<?> source) {
        this.source = source;
    }

    public boolean preReceive(MessageChannel channel) {
        Message message = this.source.receive();
        if (message != null) {
            if (this.channel != null) {
                channel = this.channel;
            }
            channel.send(message);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sent " + message + " to channel " + channel));
            }
            return true;
        }
        return true;
    }
}

