/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.file;

import java.io.IOException;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.integration.file.MessageToJobParametersStrategy;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.core.io.Resource;
import org.springframework.integration.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePayloadAsJobParameterStrategy
implements MessageToJobParametersStrategy {
    public static final String FILE_INPUT_PATH = "input.file.path";

    @Override
    public JobParameters getJobParameters(Message<?> message) {
        JobParametersBuilder builder = new JobParametersBuilder();
        Resource resource = (Resource)message.getPayload();
        try {
            builder.addString(FILE_INPUT_PATH, resource.getURL().toExternalForm());
        }
        catch (IOException e) {
            throw new ItemStreamException("Could not create URL for resource: [" + resource + "]", (Throwable)e);
        }
        return builder.toJobParameters();
    }
}

