/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.job;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.integration.job.JobExecutionRequest;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.integration.annotation.Handler;

public class StepExecutionMessageHandler {
    private Step step;
    private JobRepository jobRepository;

    @Required
    public void setStep(Step step) {
        this.step = step;
    }

    @Required
    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    @Handler
    public JobExecutionRequest handle(JobExecutionRequest request) {
        if (this.isComplete(request)) {
            return request;
        }
        JobExecution jobExecution = request.getJobExecution();
        JobInstance jobInstance = jobExecution.getJobInstance();
        StepExecution stepExecution = jobExecution.createStepExecution(this.step);
        try {
            StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, this.step);
            if (lastStepExecution != null) {
                stepExecution.setExecutionContext(lastStepExecution.getExecutionContext());
            }
            if (this.shouldStart(lastStepExecution, this.step)) {
                if (!this.isRestart(jobInstance, lastStepExecution)) {
                    stepExecution.setExecutionContext(new ExecutionContext());
                }
                this.step.execute(stepExecution);
            } else if (lastStepExecution != null) {
                stepExecution.setStatus(lastStepExecution.getStatus());
                stepExecution.setExitStatus(lastStepExecution.getExitStatus());
            }
            request.setStatus(BatchStatus.COMPLETED);
        }
        catch (Exception e) {
            this.handleFailure(request, e);
        }
        catch (Error e) {
            this.handleFailure(request, e);
            throw e;
        }
        return request;
    }

    private boolean isRestart(JobInstance jobInstance, StepExecution lastStepExecution) {
        return lastStepExecution != null && !lastStepExecution.getStatus().equals(BatchStatus.COMPLETED);
    }

    private boolean isComplete(JobExecutionRequest request) {
        return request.getStatus() == BatchStatus.FAILED || request.getStatus() == BatchStatus.STOPPED || request.getStatus() == BatchStatus.STOPPING;
    }

    private void handleFailure(JobExecutionRequest request, Throwable e) {
        request.registerThrowable(e);
        request.setStatus(BatchStatus.FAILED);
    }

    private boolean shouldStart(StepExecution lastStepExecution, Step step) throws JobExecutionException {
        if (lastStepExecution == null) {
            return true;
        }
        BatchStatus stepStatus = lastStepExecution.getStatus();
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobExecutionException("Cannot restart step from UNKNOWN status.  The last execution may have ended with a failure that could not be rolled back, so it may be dangerous to proceed.  Manual intervention is probably necessary.");
        }
        if (stepStatus == BatchStatus.COMPLETED && !step.isAllowStartIfComplete()) {
            return false;
        }
        if (this.jobRepository.getStepExecutionCount(lastStepExecution.getJobExecution().getJobInstance(), step) < step.getStartLimit()) {
            return true;
        }
        throw new StartLimitExceededException("Maximum start limit exceeded for step: " + step.getName() + "StartMax: " + step.getStartLimit());
    }
}

