/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.file;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.resource.StepExecutionResourceProxy;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.integration.item.MessageChannelItemWriter;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.xml.StaxEventItemReader;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.dispatcher.DirectChannel;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileToMessagesJobFactoryBean
implements FactoryBean,
BeanNameAware {
    private String name = "fileToMessageJob";
    private ItemReader itemReader;
    private MessageChannel channel;
    private PlatformTransactionManager transactionManager;
    private JobRepository jobRepository;

    public void setBeanName(String name) {
        this.name = name;
    }

    @Required
    public void setItemReader(ItemReader itemReader) {
        this.itemReader = itemReader;
    }

    @Required
    public void setChannel(MessageChannel channel) {
        this.channel = channel;
    }

    @Required
    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    @Required
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Object getObject() throws Exception {
        SimpleJob job = new SimpleJob();
        job.setName(this.name);
        job.setJobRepository(this.jobRepository);
        SimpleStepFactoryBean stepFactory = new SimpleStepFactoryBean();
        stepFactory.setBeanName("step");
        Assert.state((this.itemReader instanceof FlatFileItemReader || this.itemReader instanceof StaxEventItemReader ? 1 : 0) != 0, (String)"ItemReader must be either a FlatFileItemReader or a StaxEventItemReader");
        StepExecutionResourceProxy resourceProxy = new StepExecutionResourceProxy();
        resourceProxy.setFilePattern("%input.file.path%");
        stepFactory.setListeners((StepListener[])new StepExecutionListener[]{resourceProxy});
        this.setResource(this.itemReader, (Resource)resourceProxy);
        stepFactory.setItemReader(this.itemReader);
        Assert.notNull((Object)this.channel, (String)"A channel must be provided");
        Assert.state((boolean)(this.channel instanceof DirectChannel), (String)"The channel must be a DirectChannel (otherwise failures can not be recovered from)");
        MessageChannelItemWriter itemWriter = new MessageChannelItemWriter();
        itemWriter.setChannel(this.channel);
        stepFactory.setItemWriter((ItemWriter)itemWriter);
        Assert.notNull((Object)this.transactionManager, (String)"A transaction manager must be provided");
        stepFactory.setTransactionManager(this.transactionManager);
        Assert.notNull((Object)this.jobRepository, (String)"A job repository must be provided");
        stepFactory.setJobRepository(this.jobRepository);
        job.addStep((Step)stepFactory.getObject());
        return job;
    }

    private void setResource(ItemReader itemReader, Resource resource) {
        if (itemReader instanceof FlatFileItemReader) {
            ((FlatFileItemReader)itemReader).setResource(resource);
        } else {
            ((StaxEventItemReader)itemReader).setResource(resource);
        }
    }

    public Class<?> getObjectType() {
        return Job.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

