/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.listener.CompositeSkipListener;
import org.springframework.batch.core.step.skip.ItemSkipPolicy;
import org.springframework.batch.core.step.skip.NeverSkipItemSkipPolicy;
import org.springframework.batch.integration.chunk.ChunkHandler;
import org.springframework.batch.integration.chunk.ChunkRequest;
import org.springframework.batch.integration.chunk.ChunkResponse;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.integration.annotation.Handler;
import org.springframework.transaction.annotation.Transactional;

public class ItemWriterChunkHandler
implements ChunkHandler {
    private static final Log logger = LogFactory.getLog(ItemWriterChunkHandler.class);
    private ItemWriter itemWriter;
    private ItemSkipPolicy itemSkipPolicy = new NeverSkipItemSkipPolicy();
    private CompositeSkipListener skipListener = new CompositeSkipListener();

    public void setItemSkipPolicy(ItemSkipPolicy itemSkipPolicy) {
        this.itemSkipPolicy = itemSkipPolicy;
    }

    public void setItemWriter(ItemWriter itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void registerSkipListener(SkipListener listener) {
        this.skipListener.register(listener);
    }

    public void setSkipListeners(SkipListener[] skipListeners) {
        for (SkipListener listener : skipListeners) {
            this.registerSkipListener(listener);
        }
    }

    @Handler
    @Transactional
    public ChunkResponse handleChunk(ChunkRequest chunk) {
        logger.debug((Object)("Handling chunk: " + chunk));
        int parentSkipCount = chunk.getSkipCount();
        int skipCount = 0;
        try {
            for (Object item : chunk.getItems()) {
                try {
                    this.itemWriter.write(item);
                }
                catch (Exception e) {
                    if (this.itemSkipPolicy.shouldSkip((Throwable)e, parentSkipCount + skipCount)) {
                        logger.debug((Object)"Skipping item on exception", (Throwable)e);
                        ++skipCount;
                        this.skipListener.onSkipInWrite(item, (Throwable)e);
                        continue;
                    }
                    logger.debug((Object)"Cannot skip, re-throwing");
                    throw e;
                }
            }
            this.itemWriter.flush();
        }
        catch (Exception e) {
            logger.debug((Object)"Failed chunk", (Throwable)e);
            this.itemWriter.clear();
            return new ChunkResponse(ExitStatus.FAILED.addExitDescription(e.getClass().getName() + ": " + e.getMessage()), chunk.getJobId(), skipCount);
        }
        logger.debug((Object)("Completed chunk handling with " + skipCount + " skips"));
        return new ChunkResponse(ExitStatus.CONTINUABLE, chunk.getJobId(), skipCount);
    }
}

