/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.partition;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.integration.partition.StepExecutionRequest;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.core.Message;
import org.springframework.integration.gateway.MessagingGateway;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MessageEndpoint
public class MessageChannelPartitionHandler
implements PartitionHandler {
    private int gridSize = 1;
    private MessagingGateway messagingGateway;
    private String stepName;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.stepName, (String)"A step name must be provided for the remote workers.");
        Assert.state((this.messagingGateway != null ? 1 : 0) != 0, (String)"The MessagingGateway must be set");
    }

    public void setMessagingGateway(MessagingGateway messagingGateway) {
        this.messagingGateway = messagingGateway;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    @Aggregator(sendPartialResultsOnTimeout=true)
    public List<?> aggregate(List<?> messages) {
        return messages;
    }

    public Collection<StepExecution> handle(StepExecutionSplitter stepExecutionSplitter, StepExecution masterStepExecution) throws Exception {
        Set split = stepExecutionSplitter.split(masterStepExecution, this.gridSize);
        int count = 0;
        for (StepExecution stepExecution : split) {
            this.messagingGateway.send(this.createMessage(count++, split.size(), new StepExecutionRequest(this.stepName, stepExecution.getJobExecutionId(), stepExecution.getId())));
        }
        Collection result = (Collection)this.messagingGateway.receive();
        return result;
    }

    private Message<StepExecutionRequest> createMessage(int sequenceNumber, int sequenceSize, StepExecutionRequest stepExecutionRequest) {
        return MessageBuilder.withPayload((Object)stepExecutionRequest).setSequenceNumber(Integer.valueOf(sequenceNumber)).setSequenceSize(Integer.valueOf(sequenceSize)).setCorrelationId((Object)(stepExecutionRequest.getJobExecutionId() + ":" + stepExecutionRequest.getStepName())).build();
    }
}

