/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.async;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncItemProcessor<I, O>
implements ItemProcessor<I, Future<O>>,
InitializingBean {
    private ItemProcessor<I, O> delegate;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegate, (String)"The delegate must be set.");
    }

    public void setDelegate(ItemProcessor<I, O> delegate) {
        this.delegate = delegate;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public Future<O> process(final I item) throws Exception {
        FutureTask task = new FutureTask(new Callable<O>(){

            @Override
            public O call() throws Exception {
                return AsyncItemProcessor.this.delegate.process(item);
            }
        });
        this.taskExecutor.execute(task);
        return task;
    }
}

