/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.repeat.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.infrastructure.repeat.RepeatContext;
import org.springframework.batch.infrastructure.repeat.RepeatListener;
import org.springframework.batch.infrastructure.repeat.RepeatStatus;

public class CompositeRepeatListener
implements RepeatListener {
    private List<RepeatListener> listeners = new ArrayList<RepeatListener>();

    public CompositeRepeatListener() {
    }

    public CompositeRepeatListener(List<RepeatListener> listeners) {
        this.setListeners(listeners);
    }

    public CompositeRepeatListener(RepeatListener ... listeners) {
        this.setListeners(listeners);
    }

    public void setListeners(List<RepeatListener> listeners) {
        this.listeners = listeners;
    }

    public void setListeners(RepeatListener[] listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public void register(RepeatListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void after(RepeatContext context, RepeatStatus result) {
        for (RepeatListener listener : this.listeners) {
            listener.after(context, result);
        }
    }

    @Override
    public void before(RepeatContext context) {
        for (RepeatListener listener : this.listeners) {
            listener.before(context);
        }
    }

    @Override
    public void close(RepeatContext context) {
        for (RepeatListener listener : this.listeners) {
            listener.close(context);
        }
    }

    @Override
    public void onError(RepeatContext context, Throwable e) {
        for (RepeatListener listener : this.listeners) {
            listener.onError(context, e);
        }
    }

    @Override
    public void open(RepeatContext context) {
        for (RepeatListener listener : this.listeners) {
            listener.open(context);
        }
    }
}

