/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.jms.builder;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.jms.JmsItemReader;
import org.springframework.jms.core.JmsOperations;
import org.springframework.util.Assert;

public class JmsItemReaderBuilder<T> {
    protected @Nullable Class<? extends T> itemType;
    protected @Nullable JmsOperations jmsTemplate;

    public JmsItemReaderBuilder<T> jmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
        return this;
    }

    public JmsItemReaderBuilder<T> itemType(Class<? extends T> itemType) {
        this.itemType = itemType;
        return this;
    }

    public JmsItemReader<T> build() {
        Assert.notNull((Object)this.jmsTemplate, (String)"jmsTemplate is required.");
        JmsItemReader<? extends T> jmsItemReader = new JmsItemReader<T>(this.jmsTemplate);
        if (this.itemType != null) {
            jmsItemReader.setItemType(this.itemType);
        }
        return jmsItemReader;
    }
}

