/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.transform;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.batch.infrastructure.item.file.transform.ExtractorLineAggregator;

public class DelimitedLineAggregator<T>
extends ExtractorLineAggregator<T> {
    private String delimiter = ",";
    private String quoteCharacter = "";

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setQuoteCharacter(String quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    @Override
    public String doAggregate(Object[] fields) {
        return Arrays.stream(fields).map(field -> this.quoteCharacter + String.valueOf(field) + this.quoteCharacter).collect(Collectors.joining(this.delimiter));
    }
}

