/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.database.AbstractPagingItemReader;
import org.springframework.batch.infrastructure.item.database.orm.JpaQueryProvider;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JpaPagingItemReader<T>
extends AbstractPagingItemReader<T> {
    private EntityManagerFactory entityManagerFactory;
    private @Nullable EntityManager entityManager;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();
    private @Nullable String queryString;
    private @Nullable JpaQueryProvider queryProvider;
    private @Nullable Map<String, Object> parameterValues;
    private @Nullable Map<String, Object> hintValues;
    private boolean transacted = true;

    public JpaPagingItemReader(EntityManagerFactory entityManagerFactory) {
        Assert.notNull((Object)entityManagerFactory, (String)"EntityManagerFactory must not be null.");
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void setHintValues(Map<String, Object> hintValues) {
        this.hintValues = hintValues;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.queryProvider == null) {
            Assert.state((boolean)StringUtils.hasLength((String)this.queryString), (String)"Query string is required when queryProvider is null");
        }
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setQueryProvider(JpaQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    @Override
    protected void doOpen() throws Exception {
        super.doOpen();
        this.entityManager = this.entityManagerFactory.createEntityManager(this.jpaPropertyMap);
        if (this.entityManager == null) {
            throw new DataAccessResourceFailureException("Unable to obtain an EntityManager");
        }
        if (this.queryProvider != null) {
            this.queryProvider.setEntityManager(this.entityManager);
        }
    }

    @Override
    protected void doReadPage() {
        EntityTransaction tx = null;
        if (this.transacted) {
            tx = this.entityManager.getTransaction();
            tx.begin();
            this.entityManager.flush();
            this.entityManager.clear();
        }
        Query query = this.createQuery().setFirstResult(this.getPage() * this.getPageSize()).setMaxResults(this.getPageSize());
        if (this.parameterValues != null) {
            for (Map.Entry<String, Object> me : this.parameterValues.entrySet()) {
                query.setParameter(me.getKey(), me.getValue());
            }
        }
        if (this.hintValues != null) {
            this.hintValues.forEach((arg_0, arg_1) -> ((Query)query).setHint(arg_0, arg_1));
        }
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        if (!this.transacted) {
            List queryResult = query.getResultList();
            for (Object entity : queryResult) {
                this.entityManager.detach(entity);
                this.results.add(entity);
            }
        } else {
            this.results.addAll(query.getResultList());
            tx.commit();
        }
    }

    private Query createQuery() {
        if (this.queryProvider == null) {
            return this.entityManager.createQuery(this.queryString);
        }
        return this.queryProvider.createQuery();
    }

    @Override
    protected void doClose() throws Exception {
        this.entityManager.close();
        super.doClose();
    }
}

