/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.avro;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.support.AbstractItemStreamItemWriter;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;

public class AvroItemWriter<T>
extends AbstractItemStreamItemWriter<T> {
    private @Nullable DataFileWriter<T> dataFileWriter;
    private @Nullable OutputStreamWriter<T> outputStreamWriter;
    private final WritableResource resource;
    private @Nullable Resource schemaResource;
    private final Class<T> clazz;

    public AvroItemWriter(WritableResource resource, Resource schema, Class<T> clazz) {
        this(resource, clazz);
        this.schemaResource = schema;
    }

    public AvroItemWriter(WritableResource resource, Class<T> clazz) {
        this.resource = resource;
        this.clazz = clazz;
    }

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        items.forEach(item -> {
            try {
                if (this.dataFileWriter != null) {
                    this.dataFileWriter.append(item);
                } else {
                    this.outputStreamWriter.write(item);
                }
            }
            catch (Exception e) {
                throw new ItemStreamException(e.getMessage(), e);
            }
        });
    }

    @Override
    public void open(ExecutionContext executionContext) {
        super.open(executionContext);
        try {
            this.initializeWriter();
        }
        catch (IOException e) {
            throw new ItemStreamException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.dataFileWriter != null) {
                this.dataFileWriter.close();
            } else {
                this.outputStreamWriter.close();
            }
        }
        catch (IOException e) {
            throw new ItemStreamException(e.getMessage(), e);
        }
    }

    private void initializeWriter() throws IOException {
        Assert.notNull((Object)this.resource, (String)"'resource' is required.");
        Assert.notNull(this.clazz, (String)"'class' is required.");
        if (this.schemaResource != null) {
            Schema schema;
            Assert.state((boolean)this.schemaResource.exists(), (String)("'schema' " + this.schemaResource.getFilename() + " does not exist."));
            try {
                schema = new Schema.Parser().parse(this.schemaResource.getInputStream());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            this.dataFileWriter = new DataFileWriter(AvroItemWriter.datumWriterForClass(this.clazz));
            this.dataFileWriter.create(schema, this.resource.getOutputStream());
        } else {
            this.outputStreamWriter = this.createOutputStreamWriter(this.resource.getOutputStream(), AvroItemWriter.datumWriterForClass(this.clazz));
        }
    }

    private static <T> DatumWriter<T> datumWriterForClass(Class<T> clazz) {
        if (SpecificRecordBase.class.isAssignableFrom(clazz)) {
            return new SpecificDatumWriter(clazz);
        }
        if (GenericRecord.class.isAssignableFrom(clazz)) {
            return new GenericDatumWriter();
        }
        return new ReflectDatumWriter(clazz);
    }

    private OutputStreamWriter<T> createOutputStreamWriter(OutputStream outputStream, DatumWriter<T> datumWriter) {
        return new OutputStreamWriter<T>(outputStream, datumWriter);
    }

    private static class OutputStreamWriter<T> {
        private final DatumWriter<T> datumWriter;
        private final BinaryEncoder binaryEncoder;
        private final OutputStream outputStream;

        private OutputStreamWriter(OutputStream outputStream, DatumWriter<T> datumWriter) {
            this.outputStream = outputStream;
            this.datumWriter = datumWriter;
            this.binaryEncoder = EncoderFactory.get().binaryEncoder(outputStream, null);
        }

        private void write(T datum) throws Exception {
            this.datumWriter.write(datum, (Encoder)this.binaryEncoder);
            this.binaryEncoder.flush();
        }

        private void close() {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                throw new ItemStreamException(e.getMessage(), e);
            }
        }
    }
}

