/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.support.AbstractItemStreamItemReader;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;

public class ResourcesItemReader
extends AbstractItemStreamItemReader<Resource> {
    private static final String COUNT_KEY = "COUNT";
    private Resource[] resources = new Resource[0];
    private final AtomicInteger counter = new AtomicInteger(0);

    public ResourcesItemReader() {
        this.setExecutionContextName(this.getClass().getName());
    }

    public void setResources(Resource[] resources) {
        this.resources = Arrays.asList(resources).toArray(new Resource[resources.length]);
    }

    @Override
    @Nullable
    public synchronized Resource read() throws Exception {
        int index = this.counter.incrementAndGet() - 1;
        if (index >= this.resources.length) {
            return null;
        }
        return this.resources[index];
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        this.counter.set(executionContext.getInt(this.getExecutionContextKey(COUNT_KEY), 0));
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        executionContext.putInt(this.getExecutionContextKey(COUNT_KEY), this.counter.get());
    }
}

