/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SynchronizedItemStreamReader<T>
implements ItemStreamReader<T>,
InitializingBean {
    private ItemStreamReader<T> delegate;
    private final Lock lock = new ReentrantLock();

    public void setDelegate(ItemStreamReader<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public T read() throws Exception {
        this.lock.lock();
        try {
            Object t = this.delegate.read();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void open(ExecutionContext executionContext) {
        this.delegate.open(executionContext);
    }

    @Override
    public void update(ExecutionContext executionContext) {
        this.delegate.update(executionContext);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"A delegate item reader is required");
    }
}

