/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.jsr.item;

import java.io.Serializable;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.jsr.item.CheckpointSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ItemReaderAdapter<T>
extends CheckpointSupport
implements ItemReader<T> {
    private static final String CHECKPOINT_KEY = "reader.checkpoint";
    private javax.batch.api.chunk.ItemReader delegate;

    public ItemReaderAdapter(javax.batch.api.chunk.ItemReader reader) {
        super(CHECKPOINT_KEY);
        Assert.notNull((Object)reader, (String)"An ItemReader implementation is required");
        this.delegate = reader;
        this.setExecutionContextName(ClassUtils.getShortName(this.delegate.getClass()));
    }

    @Override
    @Nullable
    public T read() throws Exception {
        return (T)this.delegate.readItem();
    }

    @Override
    protected void doClose() throws Exception {
        this.delegate.close();
    }

    @Override
    protected Serializable doCheckpoint() throws Exception {
        return this.delegate.checkpointInfo();
    }

    @Override
    protected void doOpen(Serializable checkpoint) throws Exception {
        this.delegate.open(checkpoint);
    }
}

