/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.io.IOException;
import java.util.Comparator;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class LastModifiedResourceComparator
implements Comparator<Resource> {
    @Override
    public int compare(Resource r1, Resource r2) {
        Assert.isTrue((boolean)r1.exists(), (String)("Resource does not exist: " + r1));
        Assert.isTrue((boolean)r2.exists(), (String)("Resource does not exist: " + r2));
        try {
            long diff = r1.getFile().lastModified() - r2.getFile().lastModified();
            return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Resource modification times cannot be determined (unexpected).", e);
        }
    }
}

