/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.retry.ExhaustedRetryException;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryListener;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.RetryState;
import org.springframework.batch.retry.TerminatedRetryException;
import org.springframework.batch.retry.backoff.BackOffContext;
import org.springframework.batch.retry.backoff.BackOffInterruptedException;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.backoff.NoBackOffPolicy;
import org.springframework.batch.retry.policy.MapRetryContextCache;
import org.springframework.batch.retry.policy.RetryContextCache;
import org.springframework.batch.retry.policy.SimpleRetryPolicy;
import org.springframework.batch.retry.support.RetrySynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryTemplate
implements RetryOperations {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile BackOffPolicy backOffPolicy = new NoBackOffPolicy();
    private volatile RetryPolicy retryPolicy = new SimpleRetryPolicy(3, Collections.singletonMap(Exception.class, true));
    private volatile RetryListener[] listeners = new RetryListener[0];
    private RetryContextCache retryContextCache = new MapRetryContextCache();

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setListeners(RetryListener[] listeners) {
        this.listeners = Arrays.asList(listeners).toArray(new RetryListener[listeners.length]);
    }

    public void registerListener(RetryListener listener) {
        ArrayList<RetryListener> list = new ArrayList<RetryListener>(Arrays.asList(this.listeners));
        list.add(listener);
        this.listeners = list.toArray(new RetryListener[list.size()]);
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback) throws Exception {
        return this.doExecute(retryCallback, null, null);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback) throws Exception {
        return this.doExecute(retryCallback, recoveryCallback, null);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback, RetryState retryState) throws Exception, ExhaustedRetryException {
        return this.doExecute(retryCallback, null, retryState);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback, RetryState retryState) throws Exception, ExhaustedRetryException {
        return this.doExecute(retryCallback, recoveryCallback, retryState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doExecute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback, RetryState state) throws Exception, ExhaustedRetryException {
        T t;
        Throwable lastException;
        RetryContext context;
        RetryPolicy retryPolicy;
        block15: {
            T t2;
            block14: {
                retryPolicy = this.retryPolicy;
                BackOffPolicy backOffPolicy = this.backOffPolicy;
                context = this.open(retryPolicy, state);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("RetryContext retrieved: " + context));
                }
                RetrySynchronizationManager.register(context);
                lastException = null;
                try {
                    boolean running = this.doOpenInterceptors(retryCallback, context);
                    if (!running) {
                        throw new TerminatedRetryException("Retry terminated abnormally by interceptor before first attempt");
                    }
                    BackOffContext backOffContext = backOffPolicy.start(context);
                    while (this.canRetry(retryPolicy, context) && !context.isExhaustedOnly()) {
                        try {
                            this.logger.debug((Object)("Retry: count=" + context.getRetryCount()));
                            lastException = null;
                            t2 = retryCallback.doWithRetry(context);
                        }
                        catch (Throwable e) {
                            lastException = e;
                            this.doOnErrorInterceptors(retryCallback, context, e);
                            try {
                                this.registerThrowable(retryPolicy, state, context, e);
                            }
                            catch (Exception ex) {
                                throw new TerminatedRetryException("Terminated retry after error in policy", ex);
                            }
                            if (this.canRetry(retryPolicy, context) && !context.isExhaustedOnly()) {
                                try {
                                    backOffPolicy.backOff(backOffContext);
                                }
                                catch (BackOffInterruptedException ex) {
                                    lastException = e;
                                    this.logger.debug((Object)("Abort retry because interrupted: count=" + context.getRetryCount()));
                                    throw ex;
                                }
                            }
                            this.logger.debug((Object)("Checking for rethrow: count=" + context.getRetryCount()));
                            if (!this.shouldRethrow(retryPolicy, context, state)) continue;
                            this.logger.debug((Object)("Rethrow in retry for policy: count=" + context.getRetryCount()));
                            throw RetryTemplate.wrapIfNecessary(e);
                        }
                        Object var13_13 = null;
                        this.close(retryPolicy, context, state, lastException == null);
                        this.doCloseInterceptors(retryCallback, context, lastException);
                        break block14;
                    }
                    this.logger.debug((Object)("Retry failed last attempt: count=" + context.getRetryCount()));
                    if (context.isExhaustedOnly()) {
                        throw new ExhaustedRetryException("Retry exhausted after last attempt with no recovery path.", context.getLastThrowable());
                    }
                    t = this.handleRetryExhausted(recoveryCallback, context, state);
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    this.close(retryPolicy, context, state, lastException == null);
                    this.doCloseInterceptors(retryCallback, context, lastException);
                    RetrySynchronizationManager.clear();
                    throw throwable;
                }
            }
            RetrySynchronizationManager.clear();
            return t2;
        }
        Object var13_14 = null;
        this.close(retryPolicy, context, state, lastException == null);
        this.doCloseInterceptors(retryCallback, context, lastException);
        RetrySynchronizationManager.clear();
        return t;
    }

    protected boolean canRetry(RetryPolicy retryPolicy, RetryContext context) {
        return retryPolicy.canRetry(context);
    }

    protected void close(RetryPolicy retryPolicy, RetryContext context, RetryState state, boolean succeeded) {
        if (state != null) {
            if (succeeded) {
                this.retryContextCache.remove(state.getKey());
                retryPolicy.close(context);
            }
        } else {
            retryPolicy.close(context);
        }
    }

    protected void registerThrowable(RetryPolicy retryPolicy, RetryState state, RetryContext context, Throwable e) {
        if (state != null) {
            Object key = state.getKey();
            if (context.getRetryCount() > 0 && !this.retryContextCache.containsKey(key)) {
                throw new RetryException("Inconsistent state for failed item key: cache key has changed. Consider whether equals() or hashCode() for the key might be inconsistent, or if you need to supply a better key");
            }
            this.retryContextCache.put(key, context);
        }
        retryPolicy.registerThrowable(context, e);
    }

    protected RetryContext open(RetryPolicy retryPolicy, RetryState state) {
        if (state == null) {
            return this.doOpenInternal(retryPolicy);
        }
        Object key = state.getKey();
        if (state.isForceRefresh()) {
            return this.doOpenInternal(retryPolicy);
        }
        if (!this.retryContextCache.containsKey(key)) {
            return this.doOpenInternal(retryPolicy);
        }
        RetryContext context = this.retryContextCache.get(key);
        if (context == null) {
            if (this.retryContextCache.containsKey(key)) {
                throw new RetryException("Inconsistent state for failed item: no history found. Consider whether equals() or hashCode() for the item might be inconsistent, or if you need to supply a better ItemKeyGenerator");
            }
            return this.doOpenInternal(retryPolicy);
        }
        return context;
    }

    private RetryContext doOpenInternal(RetryPolicy retryPolicy) {
        return retryPolicy.open(RetrySynchronizationManager.getContext());
    }

    protected <T> T handleRetryExhausted(RecoveryCallback<T> recoveryCallback, RetryContext context, RetryState state) throws Exception {
        if (state != null) {
            this.retryContextCache.remove(state.getKey());
        }
        if (recoveryCallback != null) {
            return recoveryCallback.recover(context);
        }
        if (state != null) {
            this.logger.debug((Object)"Retry exhausted after last attempt with no recovery path.");
            throw new ExhaustedRetryException("Retry exhausted after last attempt with no recovery path", context.getLastThrowable());
        }
        throw RetryTemplate.wrapIfNecessary(context.getLastThrowable());
    }

    protected boolean shouldRethrow(RetryPolicy retryPolicy, RetryContext context, RetryState state) {
        if (state == null) {
            return false;
        }
        return state.rollbackFor(context.getLastThrowable());
    }

    private <T> boolean doOpenInterceptors(RetryCallback<T> callback, RetryContext context) {
        boolean result = true;
        for (int i = 0; i < this.listeners.length; ++i) {
            result = result && this.listeners[i].open(context, callback);
        }
        return result;
    }

    private <T> void doCloseInterceptors(RetryCallback<T> callback, RetryContext context, Throwable lastException) {
        int i = this.listeners.length;
        while (i-- > 0) {
            this.listeners[i].close(context, callback, lastException);
        }
    }

    private <T> void doOnErrorInterceptors(RetryCallback<T> callback, RetryContext context, Throwable throwable) {
        int i = this.listeners.length;
        while (i-- > 0) {
            this.listeners[i].onError(context, callback, throwable);
        }
    }

    private static Exception wrapIfNecessary(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new RetryException("Exception in batch process", throwable);
    }
}

