/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support.transaction;

import java.io.IOException;
import java.io.Writer;
import org.springframework.batch.support.transaction.FlushFailedException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareBufferedWriter
extends Writer {
    private static final String BUFFER_KEY_PREFIX = TransactionAwareBufferedWriter.class.getName() + ".BUFFER_KEY";
    private static final String CLOSE_KEY_PREFIX = TransactionAwareBufferedWriter.class.getName() + ".CLOSE_KEY";
    private final String bufferKey;
    private final String closeKey;
    private Writer writer;
    private final Runnable closeCallback;

    public TransactionAwareBufferedWriter(Writer writer, Runnable closeCallback) {
        this.writer = writer;
        this.closeCallback = closeCallback;
        this.bufferKey = BUFFER_KEY_PREFIX + "." + this.hashCode();
        this.closeKey = CLOSE_KEY_PREFIX + "." + this.hashCode();
    }

    private StringBuffer getCurrentBuffer() {
        if (!TransactionSynchronizationManager.hasResource((Object)this.bufferKey)) {
            TransactionSynchronizationManager.bindResource((Object)this.bufferKey, (Object)new StringBuffer());
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    try {
                        if (status == 0) {
                            this.complete();
                        }
                    }
                    catch (IOException e) {
                        throw new FlushFailedException("Could not write to output buffer", e);
                    }
                    finally {
                        this.clear();
                    }
                }

                private void complete() throws IOException {
                    StringBuffer buffer = (StringBuffer)TransactionSynchronizationManager.getResource((Object)TransactionAwareBufferedWriter.this.bufferKey);
                    if (buffer != null) {
                        TransactionAwareBufferedWriter.this.writer.write(buffer.toString());
                        TransactionAwareBufferedWriter.this.writer.flush();
                        if (TransactionSynchronizationManager.hasResource((Object)TransactionAwareBufferedWriter.this.closeKey)) {
                            TransactionAwareBufferedWriter.this.writer.close();
                            TransactionAwareBufferedWriter.this.closeCallback.run();
                        }
                    }
                }

                private void clear() {
                    if (TransactionSynchronizationManager.hasResource((Object)TransactionAwareBufferedWriter.this.bufferKey)) {
                        TransactionSynchronizationManager.unbindResource((Object)TransactionAwareBufferedWriter.this.bufferKey);
                    }
                    if (TransactionSynchronizationManager.hasResource((Object)TransactionAwareBufferedWriter.this.closeKey)) {
                        TransactionSynchronizationManager.unbindResource((Object)TransactionAwareBufferedWriter.this.closeKey);
                    }
                }
            });
        }
        return (StringBuffer)TransactionSynchronizationManager.getResource((Object)this.bufferKey);
    }

    public long getBufferSize() {
        if (!this.transactionActive()) {
            return 0L;
        }
        return this.getCurrentBuffer().length();
    }

    private boolean transactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public void close() throws IOException {
        if (this.transactionActive()) {
            if (this.getCurrentBuffer().length() > 0) {
                TransactionSynchronizationManager.bindResource((Object)this.closeKey, (Object)Boolean.TRUE);
            }
            return;
        }
        this.writer.close();
        this.closeCallback.run();
    }

    public void flush() throws IOException {
        if (!this.transactionActive()) {
            this.writer.flush();
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.transactionActive()) {
            this.writer.write(cbuf, off, len);
            return;
        }
        StringBuffer buffer = this.getCurrentBuffer();
        buffer.append(cbuf, off, len);
    }
}

