/*
 * Copyright 2006-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.batch.item.adapter;

import org.springframework.batch.item.ItemProcessor;

/**
 * Invokes a custom method on a delegate plain old Java object which itself
 * processes an item.
 * 
 * @author Dave Syer
 */
public class ItemProcessorAdapter<I,O> extends AbstractMethodInvokingDelegator<O> implements ItemProcessor<I,O> {

	/**
	 * Invoke the delegate method and return the result.
	 * 
	 * @see ItemProcessor#process(Object)
	 */
	public O process(I item) throws Exception {
		return invokeDelegateMethodWithArgument(item);
	}

}
