/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.batch.support.ExceptionClassifierSupport;
import org.springframework.util.Assert;

public class SubclassExceptionClassifier
extends ExceptionClassifierSupport {
    private Map classified = new HashMap();

    public final void setTypeMap(Map typeMap) {
        HashMap map = new HashMap();
        Iterator iter = typeMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.addRetryableExceptionClass(entry.getKey(), entry.getValue(), map);
        }
        this.classified = map;
    }

    public Object classify(Throwable throwable) {
        if (throwable == null) {
            return super.classify(throwable);
        }
        Class<?> exceptionClass = throwable.getClass();
        if (this.classified.containsKey(exceptionClass)) {
            return this.classified.get(exceptionClass);
        }
        TreeSet classes = new TreeSet(new ClassComparator());
        classes.addAll(this.classified.keySet());
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class cls = (Class)iterator.next();
            if (!cls.isAssignableFrom(exceptionClass)) continue;
            Object value = this.classified.get(cls);
            this.addRetryableExceptionClass(exceptionClass, value, this.classified);
            return value;
        }
        return super.classify(throwable);
    }

    private void addRetryableExceptionClass(Object candidateClass, Object classifiedAs, Map map) {
        Assert.isAssignable((Class)Class.class, candidateClass.getClass());
        Class exceptionClass = (Class)candidateClass;
        Assert.isAssignable((Class)Throwable.class, (Class)exceptionClass);
        map.put(exceptionClass, classifiedAs);
    }

    private class ClassComparator
    implements Comparator {
        private ClassComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Class cls0 = (Class)arg0;
            Class cls1 = (Class)arg1;
            if (cls0.isAssignableFrom(cls1)) {
                return 1;
            }
            return -1;
        }
    }
}

